/*
 * Decompiled with CFR 0.152.
 */
package cn.sixlab.engine.tpl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class TemplateEngine {
    public static String generateFromFiles(String tplFileName, String dataFileName, String resultFilePath) throws IOException, ScriptException {
        String tpl = TemplateEngine.readTextFile(new FileInputStream(tplFileName));
        String json = TemplateEngine.readTextFile(new FileInputStream(dataFileName));
        String result = TemplateEngine.generateFromString(tpl, json);
        File file = new File(resultFilePath);
        if (!file.exists() || !file.isFile()) {
            file.createNewFile();
        }
        FileWriter writer = new FileWriter(file);
        writer.write(result);
        writer.flush();
        writer.close();
        return result;
    }

    public static String generateFromString(String tpl, String json) throws IOException, ScriptException {
        InputStream is = TemplateEngine.class.getResourceAsStream("/juicer-min.js");
        String juicer = TemplateEngine.readTextFile(is);
        tpl = tpl.replaceAll("'", "'");
        tpl = tpl.replaceAll("\n", "','");
        StringBuffer sb = new StringBuffer();
        sb.append(" var tplArray = ['");
        sb.append(tpl);
        sb.append("']; \n ");
        sb.append(" var tpl = tplArray.join('\\n'); \n ");
        sb.append(" var data= " + json + " ; \n ");
        sb.append(juicer + " \n ");
        sb.append(" juicer(tpl,data); ");
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("nashorn");
        return (String)engine.eval(sb.toString());
    }

    protected static String readTextFile(InputStream is) throws IOException {
        String line;
        InputStreamReader isReader = new InputStreamReader(is);
        BufferedReader reader = new BufferedReader(isReader);
        StringBuffer sb = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            sb.append(line + "\n");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }
}

