package cn.siriusbot.siriuspro.bot.api;

import cn.siriusbot.siriuspro.bot.api.pojo.User;
import lombok.NonNull;

import java.util.List;

public interface SiriusUtils {
    enum MatchState {
        /**
         * 未通过
         */
        NOT_PASS,
        /**
         * 未通过正则
         */
        NOT_PASS_RE,
        /**
         * 通过
         */
        PASS;

        @Override
        public String toString() {
            return String.valueOf(this.ordinal());
        }
    }

    /**
     * 匹配指令
     *
     * @param botId   机器人ID
     * @param content 消息内容
     * @param cmd     指令前缀
     * @param re      正则
     * @param params  参数值
     * @return 0 未匹配 1 已匹配 2 匹配指令但未匹配正则
     */
    MatchState matchCmd(String botId, String content, String cmd, String re, @NonNull List<String> params);

    String at(User user);

    String at(String userId);
}
