package cn.siriusbot.siriuspro.bot.api;

import java.util.List;

/**
 * 配置相关API
 */
public interface ConfigApi {

    /**
     * 读配置项
     * @param database      数据库名(->易语言中的文件名)
     * @param node          节点名
     * @param config        配置项名
     * @param defaultVal    如果为空时默认值
     * @return  读取结果
     */
    String readConfig(String database, String node, String config, String defaultVal);

    /**
     * 写配置项
     * @param database  数据库名(->易语言中的文件名)
     * @param node      节点名
     * @param config    配置项名
     * @param value     写入值
     */
    void writeConfig(String database, String node, String config, String value);

    /**
     * 获取数据库下的节名列表
     * @param database  数据库名(->易语言中的文件名)
     * @return  节名列表对象
     */
    List<String> getNodeList(String database);

    /**
     * 获取节名下的配置项名列表
     * @param database  数据库名(->易语言中的文件名)
     * @param node      节名
     * @return  配置项名列表
     */
    List<String> getConfigList(String database, String node);

    /**
     * 获取数据库列表
     * @return  数据库名列表
     */
    List<String> getDataBaseList();



    /**
     * 删除数据库
     * @param database  数据库名(->易语言中的文件名)
     */
    void delDatabase(String database);

    /**
     * 删除节名
     * @param database  数据库名(->易语言中的文件名)
     * @param node      节名
     */
    void delNode(String database, String node);

    /**
     * 删除配置项
     * @param database  数据库名(->易语言中的文件名)
     * @param node      节名
     * @param config    配置项名
     */
    void delConfig(String database, String node, String config);
}
