package cn.siriusbot.siriuspro.admin.entity.vo;

import cn.siriusbot.siriuspro.admin.entity.Intent;
import cn.siriusbot.siriuspro.admin.entity.Robot;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
public class RobotInfo extends Robot {

    /**
     * 是否在线 0 未登录 1 登录中 2 已登录  3 登录失败
     */
    Integer state = 0;

    /**
     * 机器人昵称
     */
    String username;


    /**
     * 错误原因
     */
    String errorInfo;

    List<Intent> intents;


    public static final int STATE_READY = 0;    // 未登录
    public static final int STATE_PROCEED = 1;    // 登录中
    public static final int STATE_ONLINE = 2;    // 已登录
    public static final int STATE_ERROR = 3;    // 登录异常
    public static final int STATE_RECONNECTION = 4;    // 重连中

}
