package cn.sinozg.applet.biz.system.vo.response;

import cn.sinozg.applet.biz.system.vo.request.OrderPaymentDetailAmount;
import cn.sinozg.applet.biz.system.vo.request.OrderPaymentPayer;
import cn.sinozg.applet.biz.system.vo.request.OrderPaymentScene;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

/**
* 微信支付回调接口响应封装对象
 * 详情
* @Author: xyb
* @Description: 
* @Date: 2023-03-24 下午 10:52
**/
public class PaymentCallbackDetail implements Serializable {
    /**
     * 小程序ID
     */
    @JsonProperty(value = "appid")
    private String appId;
    /**
     * 商户号
     */
    @JsonProperty(value = "mchid")
    private String mchId;
    /**
     * 商户订单号
     */
    @JsonProperty(value = "out_trade_no")
    private String outTradeNo;

	/** 微信支付订单号*/
    @JsonProperty(value = "transaction_id")
    private String transactionId;
    /** 交易类型*/
    @JsonProperty(value = "trade_type")
    private String tradeType;
    /** 交易状态 */
    @JsonProperty(value = "trade_state")
    private String tradeState;
    /** 交易状态描述 */
    @JsonProperty(value = "trade_state_desc")
    private String tradeStateDesc;
    /** 付款银行 */
    @JsonProperty(value = "bank_type")
    private String bankType;
    /** 支付完成时间 */
    @JsonProperty(value = "success_time")
    private String successTime;
    /**若失败则为异常信息*/
    @JsonProperty(value = "amount")
    private OrderPaymentDetailAmount amount;
    /**若失败则为异常信息*/
    @JsonProperty(value = "payer")
    private OrderPaymentPayer payer;
    /** 场景信息 */
    @JsonProperty(value = "scene_info")
    private OrderPaymentScene scene;

    /**
     * 获取 小程序ID
     *
     * @return appId 小程序ID
     */
    public String getAppId() {
        return this.appId;
    }

    /**
     * 设置 小程序ID
     *
     * @param appId 小程序ID
     */
    public void setAppId(String appId) {
        this.appId = appId;
    }

    /**
     * 获取 商户号
     *
     * @return mchId 商户号
     */
    public String getMchId() {
        return this.mchId;
    }

    /**
     * 设置 商户号
     *
     * @param mchId 商户号
     */
    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    /**
     * 获取 商户订单号
     *
     * @return outTradeNo 商户订单号
     */
    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    /**
     * 设置 商户订单号
     *
     * @param outTradeNo 商户订单号
     */
    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    /**
     * 获取 微信支付订单号
     *
     * @return transactionId 微信支付订单号
     */
    public String getTransactionId() {
        return this.transactionId;
    }

    /**
     * 设置 微信支付订单号
     *
     * @param transactionId 微信支付订单号
     */
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    /**
     * 获取 交易类型
     *
     * @return tradeType 交易类型
     */
    public String getTradeType() {
        return this.tradeType;
    }

    /**
     * 设置 交易类型
     *
     * @param tradeType 交易类型
     */
    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    /**
     * 获取 交易状态
     *
     * @return tradeState 交易状态
     */
    public String getTradeState() {
        return this.tradeState;
    }

    /**
     * 设置 交易状态
     *
     * @param tradeState 交易状态
     */
    public void setTradeState(String tradeState) {
        this.tradeState = tradeState;
    }

    /**
     * 获取 交易状态描述
     *
     * @return tradeStateDesc 交易状态描述
     */
    public String getTradeStateDesc() {
        return this.tradeStateDesc;
    }

    /**
     * 设置 交易状态描述
     *
     * @param tradeStateDesc 交易状态描述
     */
    public void setTradeStateDesc(String tradeStateDesc) {
        this.tradeStateDesc = tradeStateDesc;
    }

    /**
     * 获取 付款银行
     *
     * @return bankType 付款银行
     */
    public String getBankType() {
        return this.bankType;
    }

    /**
     * 设置 付款银行
     *
     * @param bankType 付款银行
     */
    public void setBankType(String bankType) {
        this.bankType = bankType;
    }

    /**
     * 获取 支付完成时间
     *
     * @return successTime 支付完成时间
     */
    public String getSuccessTime() {
        return this.successTime;
    }

    /**
     * 设置 支付完成时间
     *
     * @param successTime 支付完成时间
     */
    public void setSuccessTime(String successTime) {
        this.successTime = successTime;
    }

    /**
     * 获取 若失败则为异常信息
     *
     * @return amount 若失败则为异常信息
     */
    public OrderPaymentDetailAmount getAmount() {
        return this.amount;
    }

    /**
     * 设置 若失败则为异常信息
     *
     * @param amount 若失败则为异常信息
     */
    public void setAmount(OrderPaymentDetailAmount amount) {
        this.amount = amount;
    }

    /**
     * 获取 若失败则为异常信息
     *
     * @return payer 若失败则为异常信息
     */
    public OrderPaymentPayer getPayer() {
        return this.payer;
    }

    /**
     * 设置 若失败则为异常信息
     *
     * @param payer 若失败则为异常信息
     */
    public void setPayer(OrderPaymentPayer payer) {
        this.payer = payer;
    }

    /**
     * 获取 场景信息
     *
     * @return scene 场景信息
     */
    public OrderPaymentScene getScene() {
        return this.scene;
    }

    /**
     * 设置 场景信息
     *
     * @param scene 场景信息
     */
    public void setScene(OrderPaymentScene scene) {
        this.scene = scene;
    }
}
