package cn.sinozg.applet.biz.system.vo.response;

import cn.sinozg.applet.biz.system.vo.request.OrderRefundAmountFrom;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
* 微信退款返回返回封装对象
* @Author: xyb
* @Description: 
* @Date: 2023-04-06 下午 09:48
**/
public class OrderRefundResponseAmount {
    /**
     * 订单总金额，单位为分
     */
    @JsonProperty(value = "total")
    private int total;
    /**
     * 退款金额，单位为分
     */
    @JsonProperty(value = "refund")
    private int refund;
    /**
     * 用户支付金额
     */
    @JsonProperty(value = "payer_total")
    private int payerTotal;
    /**
     * 用户退款金额
     */
    @JsonProperty(value = "payer_refund")
    private int payerRefund;
    /**
     * 应结退款金额
     */
    @JsonProperty(value = "settlement_refund")
    private int settlementRefund;
    /**
     * 应结订单金额
     */
    @JsonProperty(value = "settlement_total")
    private int settlementTotal;
    /**
     * 优惠退款金额
     */
    @JsonProperty(value = "discount_refund")
    private int discountRefund;
    /**
     * 手续费退款金额
     */
    @JsonProperty(value = "refund_fee")
    private int refundFee;

    /**
     * CNY：人民币，境内商户号仅支持人民币。
     */
    @JsonProperty(value = "currency")
    private String currency;
    /**
     * 退款出资账户及金额
     */
    @JsonProperty(value = "from")
    private List<OrderRefundAmountFrom> from;

    /**
     * 获取 订单总金额，单位为分
     *
     * @return total 订单总金额，单位为分
     */
    public int getTotal() {
        return this.total;
    }

    /**
     * 设置 订单总金额，单位为分
     *
     * @param total 订单总金额，单位为分
     */
    public void setTotal(int total) {
        this.total = total;
    }

    /**
     * 获取 退款金额，单位为分
     *
     * @return refund 退款金额，单位为分
     */
    public int getRefund() {
        return this.refund;
    }

    /**
     * 设置 退款金额，单位为分
     *
     * @param refund 退款金额，单位为分
     */
    public void setRefund(int refund) {
        this.refund = refund;
    }

    /**
     * 获取 用户支付金额
     *
     * @return payerTotal 用户支付金额
     */
    public int getPayerTotal() {
        return this.payerTotal;
    }

    /**
     * 设置 用户支付金额
     *
     * @param payerTotal 用户支付金额
     */
    public void setPayerTotal(int payerTotal) {
        this.payerTotal = payerTotal;
    }

    /**
     * 获取 用户退款金额
     *
     * @return payerRefund 用户退款金额
     */
    public int getPayerRefund() {
        return this.payerRefund;
    }

    /**
     * 设置 用户退款金额
     *
     * @param payerRefund 用户退款金额
     */
    public void setPayerRefund(int payerRefund) {
        this.payerRefund = payerRefund;
    }

    /**
     * 获取 应结退款金额
     *
     * @return settlementRefund 应结退款金额
     */
    public int getSettlementRefund() {
        return this.settlementRefund;
    }

    /**
     * 设置 应结退款金额
     *
     * @param settlementRefund 应结退款金额
     */
    public void setSettlementRefund(int settlementRefund) {
        this.settlementRefund = settlementRefund;
    }

    /**
     * 获取 应结订单金额
     *
     * @return settlementTotal 应结订单金额
     */
    public int getSettlementTotal() {
        return this.settlementTotal;
    }

    /**
     * 设置 应结订单金额
     *
     * @param settlementTotal 应结订单金额
     */
    public void setSettlementTotal(int settlementTotal) {
        this.settlementTotal = settlementTotal;
    }

    /**
     * 获取 优惠退款金额
     *
     * @return discountRefund 优惠退款金额
     */
    public int getDiscountRefund() {
        return this.discountRefund;
    }

    /**
     * 设置 优惠退款金额
     *
     * @param discountRefund 优惠退款金额
     */
    public void setDiscountRefund(int discountRefund) {
        this.discountRefund = discountRefund;
    }

    /**
     * 获取 手续费退款金额
     *
     * @return refundFee 手续费退款金额
     */
    public int getRefundFee() {
        return this.refundFee;
    }

    /**
     * 设置 手续费退款金额
     *
     * @param refundFee 手续费退款金额
     */
    public void setRefundFee(int refundFee) {
        this.refundFee = refundFee;
    }

    /**
     * 获取 CNY：人民币，境内商户号仅支持人民币。
     *
     * @return currency CNY：人民币，境内商户号仅支持人民币。
     */
    public String getCurrency() {
        return this.currency;
    }

    /**
     * 设置 CNY：人民币，境内商户号仅支持人民币。
     *
     * @param currency CNY：人民币，境内商户号仅支持人民币。
     */
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    /**
     * 获取 退款出资账户及金额
     *
     * @return from 退款出资账户及金额
     */
    public List<OrderRefundAmountFrom> getFrom() {
        return this.from;
    }

    /**
     * 设置 退款出资账户及金额
     *
     * @param from 退款出资账户及金额
     */
    public void setFrom(List<OrderRefundAmountFrom> from) {
        this.from = from;
    }
}
