package cn.sinozg.applet.biz.system.service;

import cn.sinozg.applet.biz.system.vo.request.WebPaymentRequest;
import cn.sinozg.applet.biz.system.vo.request.WebRefundRequest;
import cn.sinozg.applet.biz.system.vo.response.OrderRefundResponse;
import cn.sinozg.applet.biz.system.vo.response.PaymentCallbackResponse;

import javax.servlet.http.HttpServletRequest;

/**
 * 小程序支付相关的接口
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-22 下午 06:40
 **/
public interface PaymentService {
    /**
     * 申请支付
     * @param param 支付信息
     * @return 支付id
     */
    String payment (WebPaymentRequest param);

    /**
     * 关闭订单
     * @param outTradeNo 订单编号
     * @return 是否成功
     */
    boolean closeOrder (String outTradeNo);

    /**
     * 支付回调
     * @param request HttpServletRequest
     * @return 回调结果
     */
    PaymentCallbackResponse paymentCallback(HttpServletRequest request);

    /**
     * 退款申请
     * @param params 退款请求参数
     * @return 退款返回参数
     */
    OrderRefundResponse refund (WebRefundRequest params);


    /**
     * 退款申请回调
     * @param request HttpServletRequest
     * @return 申请回调结果
     */
    PaymentCallbackResponse refundCallBack(HttpServletRequest request);
}
