package cn.sinozg.applet.biz.system.vo.request;

import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotEmpty;

/**
 * 前端传入的订单支付信息
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-24 下午 09:35
 **/
public class WebPaymentRequest {
    /**订单ID*/
    @NotEmpty(message = "{TIRSCI.WebPaymentRequest.orderId}")
    @Schema(description = "订单ID")
    private String orderId;
    /**商品金额*/
    @Schema(description = "商品金额")
    private int totalFee;
    @NotEmpty(message = "{TIRSCI.WebPaymentRequest.description}")
    @Schema(description = "商铺描述")
    private String description;

    /**
     * 获取 订单ID
     *
     * @return orderId 订单ID
     */
    public String getOrderId() {
        return this.orderId;
    }

    /**
     * 设置 订单ID
     *
     * @param orderId 订单ID
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * 获取 商品金额
     *
     * @return totalFee 商品金额
     */
    public int getTotalFee() {
        return this.totalFee;
    }

    /**
     * 设置 商品金额
     *
     * @param totalFee 商品金额
     */
    public void setTotalFee(int totalFee) {
        this.totalFee = totalFee;
    }

    /**
     * 获取 @NotEmpty(message = "{TIRSCI.WebPaymentRequest.description}")    @Schema(description = "商铺描述")
     *
     * @return description @NotEmpty(message = "{TIRSCI.WebPaymentRequest.description}")    @Schema(description = "商铺描述")
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * 设置 @NotEmpty(message = "{TIRSCI.WebPaymentRequest.description}")    @Schema(description = "商铺描述")
     *
     * @param description @NotEmpty(message = "{TIRSCI.WebPaymentRequest.description}")    @Schema(description = "商铺描述")
     */
    public void setDescription(String description) {
        this.description = description;
    }
}