/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import ai.chat2db.excel.EasyExcel;
import ai.chat2db.excel.ExcelWriter;
import ai.chat2db.excel.annotation.ExcelProperty;
import ai.chat2db.excel.read.builder.ExcelReaderBuilder;
import ai.chat2db.excel.read.builder.ExcelReaderSheetBuilder;
import ai.chat2db.excel.write.builder.ExcelWriterBuilder;
import ai.chat2db.excel.write.builder.ExcelWriterSheetBuilder;
import ai.chat2db.excel.write.handler.WriteHandler;
import ai.chat2db.excel.write.metadata.WriteSheet;
import ai.chat2db.excel.write.metadata.fill.FillConfig;
import ai.chat2db.excel.write.metadata.style.WriteCellStyle;
import ai.chat2db.excel.write.metadata.style.WriteFont;
import ai.chat2db.excel.write.style.HorizontalCellStyleStrategy;
import cn.sinozg.applet.common.core.model.ExportData;
import cn.sinozg.applet.common.core.model.ImportExcelResult;
import cn.sinozg.applet.common.excel.EasyExcelReadListener;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.DowUtil;
import cn.sinozg.applet.common.utils.FileUtil;
import cn.sinozg.applet.common.utils.I18nUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.SnowFlake;
import cn.sinozg.applet.common.utils.WebUtil;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static <T> List<T> importExcel(MultipartFile file, Class<T> clazz) {
        return ExcelUtil.importExcel(file, f -> f, clazz).getData();
    }

    public static <T> List<T> importExcelStart0(MultipartFile file, Class<T> clazz) {
        return ExcelUtil.importExcel(file, f -> f, e -> e.headRowNumber(Integer.valueOf(0)), clazz).getData();
    }

    public static <T, U> ImportExcelResult<U> importExcel(MultipartFile file, Function<T, U> function, Class<T> clazz) {
        return ExcelUtil.importExcel(file, function, null, clazz);
    }

    public static <T, U> ImportExcelResult<U> importExcel(MultipartFile file, Function<T, U> function, Consumer<ExcelReaderSheetBuilder> excel, Class<T> clazz) {
        ImportExcelResult result = new ImportExcelResult();
        if (!FileUtil.judgeFile((MultipartFile)file, (String[])new String[]{".xls", ".xlsx"})) {
            throw new CavException("BIZ000100027");
        }
        EasyExcelReadListener<T, U> listener = new EasyExcelReadListener<T, U>(function, result);
        try (InputStream is = file.getInputStream();){
            ExcelReaderSheetBuilder builder = ((ExcelReaderBuilder)EasyExcel.read((InputStream)is, listener).head(clazz)).sheet();
            if (excel != null) {
                excel.accept(builder);
            }
            builder.doRead();
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6excel\u9519\u8bef\uff0c{}\uff0c {}", (Object)file.getOriginalFilename(), (Object)e.getMessage());
            throw new CavException("BIZ000100026");
        }
        return result;
    }

    public static <T> void exportWithTemp(HttpServletResponse response, String tempPath, List<T> exportData, Object otherInfo) {
        String fileName = StringUtils.substringAfterLast((String)tempPath, (String)"/");
        ExcelUtil.setResponse(response, fileName, false);
        ClassPathResource classPathResource = new ClassPathResource(tempPath);
        try (InputStream inputStream = classPathResource.getInputStream();
             ServletOutputStream os = response.getOutputStream();
             BufferedOutputStream bos = new BufferedOutputStream((OutputStream)os);
             ExcelWriter excelWriter = EasyExcel.write((OutputStream)bos).withTemplate(inputStream).build();){
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
            excelWriter.fill(exportData, fillConfig, writeSheet);
            if (otherInfo != null) {
                excelWriter.fill(otherInfo, writeSheet);
            }
            excelWriter.finish();
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u6a21\u677fexcel\u6587\u4ef6\u5bfc\u51faexcel\u5931\u8d25:", (Throwable)e);
            throw new CavException("BIZ000100024");
        }
    }

    public static <T> void exportSingleFile(HttpServletResponse response, String fileName, List<T> exportData, String sheetName) {
        if (CollectionUtils.isEmpty(exportData)) {
            throw new CavException("BIZ000100025");
        }
        ExcelUtil.exportFile(fileName, PojoUtil.arrayToList((Object[])new List[]{exportData}), response, sheetName);
    }

    public static <T> void exportSingleFile(HttpServletResponse response, String fileName, ExportData<T> exportData, Consumer<ExcelWriterBuilder> writeConsumer) {
        if (CollectionUtils.isEmpty(exportData.getSheetData())) {
            throw new CavException("BIZ000100025");
        }
        List<ExportData<T>> list = Collections.singletonList(exportData);
        ExcelUtil.exportFile(fileName, list, writeConsumer, response);
    }

    public static <T> void exportFile(String fileName, List<List<T>> exportData, HttpServletResponse response, String ... sheetNames) {
        ArrayList<ExportData<T>> list = new ArrayList<ExportData<T>>();
        for (int itemIndex = 0; itemIndex < exportData.size(); ++itemIndex) {
            ExportData<T> exportDataItem = new ExportData<T>();
            if (ArrayUtils.isNotEmpty((Object[])sheetNames) && sheetNames.length >= itemIndex) {
                exportDataItem.setSheetName(sheetNames[itemIndex]);
            }
            exportDataItem.setSheetData(exportData.get(itemIndex));
            list.add(exportDataItem);
        }
        ExcelUtil.exportFile(fileName, list, null, response);
    }

    public static <T> void exportFile(String fileName, List<ExportData<T>> exportData, Consumer<ExcelWriterBuilder> writeConsumer, HttpServletResponse response) {
        if (Objects.isNull(response) || CollectionUtils.isEmpty(exportData)) {
            log.error("ExcelUtil exportFile required param can't be empty");
            throw new CavException("BIZ000100025");
        }
        ExcelUtil.setResponse(response, fileName);
        try (ServletOutputStream os = response.getOutputStream();
             BufferedOutputStream bos = new BufferedOutputStream((OutputStream)os);){
            ExcelWriterBuilder writerBuild = EasyExcel.write((OutputStream)bos);
            if (writeConsumer != null) {
                writeConsumer.accept(writerBuild);
            } else {
                writerBuild.registerWriteHandler((WriteHandler)ExcelUtil.getExportDefaultStyle());
            }
            try (ExcelWriter writer = writerBuild.build();){
                for (int itemIndex = 0; itemIndex < exportData.size(); ++itemIndex) {
                    ExportData<T> ed = exportData.get(itemIndex);
                    List<T> list = ed.getSheetData();
                    Object sheetName = "sheet" + (itemIndex + 1);
                    if (StringUtils.isNotBlank((CharSequence)ed.getSheetName())) {
                        sheetName = ed.getSheetName();
                    }
                    ExcelWriterSheetBuilder sheet = EasyExcel.writerSheet((Integer)itemIndex, (String)sheetName);
                    Consumer<ExcelWriterSheetBuilder> sheetConsumer = ed.getSheetConsumer();
                    if (sheetConsumer != null) {
                        sheetConsumer.accept(sheet);
                    } else {
                        Class<?> clazz = list.get(0).getClass();
                        if (ed.isI18nHeader()) {
                            sheet.head(ExcelUtil.i18nHeader(clazz));
                        } else {
                            sheet.head(clazz);
                        }
                    }
                    writer.write(list, sheet.build());
                }
            }
        }
        catch (Exception e) {
            log.error("ExcelUtil exportFile in error:", (Throwable)e);
            throw new CavException("BIZ000100024");
        }
    }

    public static void downloadExcelTemp(HttpServletResponse response, String tempName) {
        ClassPathResource classPathResource = new ClassPathResource(tempName);
        try (InputStream inputStream = classPathResource.getInputStream();){
            DowUtil.download((HttpServletResponse)response, (String)tempName, (byte[])IOUtils.toByteArray((InputStream)inputStream), null);
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7dexcel \u6a21\u7248\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    public static void setResponse(HttpServletResponse response, String fileName) {
        ExcelUtil.setResponse(response, fileName, true);
    }

    private static void setResponse(HttpServletResponse response, String fileName, boolean rename) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = SnowFlake.genId() + ".xlsx";
        } else if (rename) {
            String[] arrays = StringUtils.split((String)fileName, (String)".");
            fileName = String.format("%s(%s).%s", arrays[0], DateUtil.formatDateTime((LocalDateTime)LocalDateTime.now(), (String)"MMddHHmmssSSS"), arrays[1]);
        }
        DowUtil.setResponse((HttpServletResponse)response, (String)fileName, null);
    }

    private static HorizontalCellStyleStrategy getExportDefaultStyle() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setBold(Boolean.valueOf(true));
        headWriteCellStyle.setWriteFont(headWriteFont);
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }

    private static List<List<String>> i18nHeader(Class<?> clazz) {
        ArrayList<List<String>> heads = new ArrayList<List<String>>();
        Field[] fields = clazz.getDeclaredFields();
        HttpServletRequest request = WebUtil.request();
        for (Field field : fields) {
            ExcelProperty ep = field.getAnnotation(ExcelProperty.class);
            if (ep == null || !ArrayUtils.isNotEmpty((Object[])ep.value())) continue;
            String code = ep.value()[0];
            heads.add(List.of(I18nUtil.propertyName((HttpServletRequest)request, (String)code, (Object[])new Object[0])));
        }
        return heads;
    }
}

