/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.model;

import java.util.List;

/**
 * 封装导入的结果信息
 * @Author: xyb
 * @Description:
 * @Date: 2023-05-01 下午 02:42
 **/
public class ImportExcelResult<T> {

    /** 导入过程中的错误信息 (可用于记录解析excel数据时存储异常信息，用于业务的事务的回滚) */
    private List<String> errorInfo;

    /** 结果集 */
    private List<T> data;

    /**
     * 获取 导入过程中的错误信息
     *
     * @return errorInfo 导入过程中的错误信息
     */
    public List<String> getErrorInfo() {
        return this.errorInfo;
    }

    /**
     * 设置 导入过程中的错误信息
     *
     * @param errorInfo 导入过程中的错误信息
     */
    public void setErrorInfo(List<String> errorInfo) {
        this.errorInfo = errorInfo;
    }

    /**
     * 获取 结果集
     *
     * @return data 结果集
     */
    public List<T> getData() {
        return this.data;
    }

    /**
     * 设置 结果集
     *
     * @param data 结果集
     */
    public void setData(List<T> data) {
        this.data = data;
    }
}