package cn.sinozg.applet.mq.service;

import cn.sinozg.applet.common.service.FrameworkInitRunService;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.SpringUtil;
import cn.sinozg.applet.mq.handle.ConsumerAutoHandler;
import cn.sinozg.applet.mq.mq.MqConsumer;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 自动消费 实现了
 * @see ConsumerAutoHandler 的类
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-18 19:20
 */
@Service
public class AutoConsumerServiceImpl implements FrameworkInitRunService {

    @Override
    public void initInfo() {
        Map<String, ConsumerAutoHandler<Object>> map = PojoUtil.cast(SpringUtil.beansOfType(ConsumerAutoHandler.class));
        for (Map.Entry<String, ConsumerAutoHandler<Object>> e : map.entrySet()) {
            ConsumerAutoHandler<Object> handler = e.getValue();
            handler.initialization();
            MqConsumer<Object> consumer = handler.consumer();
            if (consumer != null) {
                consumer.consume(handler.type(), handler);
            }
        }
    }
}
