/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.mq.vertx.verticle;

import cn.sinozg.applet.mq.handle.ConsumerHandler;
import cn.sinozg.applet.mq.vertx.BeanCodec;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;

/**
 * 消费者
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2023
 * @since 2023-11-20 12:28
 */
public class ConsumerVerticle<T> extends AbstractVerticle {

    private final Class<T> clazz;
    private EventBus eventBus;

    public ConsumerVerticle(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void start() {
        eventBus = vertx.eventBus();
        eventBus.registerCodec(new BeanCodec<>(clazz));
    }

    public void consume(String topic, ConsumerHandler<T> handler) {
        eventBus.consumer(topic, (Handler<Message<T>>) msg -> handler.handler(msg.body()));
    }
}

