/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.mq.vertx.handle;


import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.mq.joint.BaseTopicType;
import cn.sinozg.applet.mq.mq.MqProducer;
import cn.sinozg.applet.mq.vertx.VertxManager;
import cn.sinozg.applet.mq.vertx.verticle.ProducerVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.CountDownLatch;

/**
 * Vertx 模式下的 生产者
 * @Description
 * @Copyright Copyright (c) 2023
 * @author xieyubin
 * @since 2023-11-20 12:32:43
 */
public class VertxMqProducer<T> implements MqProducer<T> {

    private final ProducerVerticle<T> producerVerticle;

    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private static final Logger log = LoggerFactory.getLogger(VertxMqProducer.class);

    public VertxMqProducer(Class<T> clazz) {
        producerVerticle = new ProducerVerticle<>(clazz);
        VertxManager.instance().deployVerticle(producerVerticle).onComplete(h -> countDownLatch.countDown());
        //等待初始化完成
        try {

            countDownLatch.await();
        } catch (Exception e) {
            log.error("初始化 VertxMqProducer 失败！", e);
            throw new CavException("BIZ000100059");
        }
    }

    @Override
    public void publish(BaseTopicType topic, T msg) {
        producerVerticle.publish(topic.topic(), msg);
    }

    @Override
    public void publish(String topic, T msg) {
        producerVerticle.publish(topic, msg);
    }
}
