/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.mq.vertx;

import cn.sinozg.applet.common.utils.JsonUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.Json;

public class BeanCodec<T>
implements MessageCodec<T, T> {
    private final Class<T> beanType;

    public BeanCodec(Class<T> cls) {
        this.beanType = cls;
    }

    public void encodeToWire(Buffer buffer, T o) {
        String json = Json.encode(o);
        Buffer encoded = Buffer.buffer((String)json);
        buffer.appendInt(encoded.length());
        buffer.appendBuffer(encoded);
    }

    public T decodeFromWire(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        return (T)Json.decodeValue((Buffer)buffer.slice(pos += 4, pos + length), this.beanType);
    }

    public T transform(T o) {
        return (T)JsonUtil.toPojo((String)JsonUtil.toJson(o), this.beanType);
    }

    public String name() {
        return this.beanType.getSimpleName();
    }

    public byte systemCodecID() {
        return -1;
    }
}

