/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.mq.vertx.verticle;

import cn.sinozg.applet.mq.vertx.BeanCodec;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;

/**
 * 生产者
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2023
 * @since 2023-11-20 12:29
 */
public class ProducerVerticle <T> extends AbstractVerticle {

    private final Class<T> clazz;
    private EventBus eventBus;

    public ProducerVerticle(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void start() {
        eventBus = vertx.eventBus();
        eventBus.registerCodec(new BeanCodec<>(clazz));
    }

    public void publish(String topic, T msg) {
        eventBus.publish(topic, msg, new DeliveryOptions().setCodecName(clazz.getSimpleName()));
    }
}
