/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.mq.vertx.handle;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.mq.handle.ConsumerHandler;
import cn.sinozg.applet.mq.joint.BaseTopicType;
import cn.sinozg.applet.mq.mq.MqConsumer;
import cn.sinozg.applet.mq.vertx.VertxManager;
import cn.sinozg.applet.mq.vertx.verticle.ConsumerVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.CountDownLatch;

/**
 * Vertx 模式下的 消费者
 * @Description
 * @Copyright Copyright (c) 2023
 * @author xieyubin
 * @since 2023-11-20 12:34:19
 */
public class VertxMqConsumer<T> implements MqConsumer<T> {

    private final ConsumerVerticle<T> consumerVerticle;

    private final CountDownLatch countDownLatch = new CountDownLatch(1);

    private static final Logger log = LoggerFactory.getLogger(VertxMqConsumer.class);

    public VertxMqConsumer(Class<T> clazz) {
        consumerVerticle = new ConsumerVerticle<>(clazz);
        VertxManager.instance().deployVerticle(consumerVerticle, result -> countDownLatch.countDown());
        //等待初始化完成
        try {
            countDownLatch.await();
        } catch (Exception e) {
            log.error("初始化 VertxMqConsumer 失败！", e);
            throw new CavException("BIZ000100058");
        }
    }

    @Override
    public void consume(BaseTopicType topic, ConsumerHandler<T> handler) {
        consumerVerticle.consume(topic.topic(), handler);
    }

    @Override
    public void consume(String topic, ConsumerHandler<T> handler) {
        consumerVerticle.consume(topic, handler);
    }
}
