package cn.sinozg.applet.mq.vertx.verticle;

import cn.sinozg.applet.mq.handle.ConsumerHandler;
import cn.sinozg.applet.mq.vertx.BeanCodec;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;

/**
 * 消费者
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2023
 * @since 2023-11-20 12:28
 */
public class ConsumerVerticle<T> extends AbstractVerticle {

    private final Class<T> clazz;
    private EventBus eventBus;

    public ConsumerVerticle(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void start() {
        eventBus = vertx.eventBus();
        eventBus.registerCodec(new BeanCodec<>(clazz));
    }

    public void consume(String topic, ConsumerHandler<T> handler) {
        eventBus.consumer(topic, (Handler<Message<T>>) msg -> handler.handler(msg.body()));
    }
}

