package cn.sinozg.applet.mq.vertx.verticle;

import cn.sinozg.applet.mq.vertx.BeanCodec;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;

/**
 * 生产者
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2023
 * @since 2023-11-20 12:29
 */
public class ProducerVerticle <T> extends AbstractVerticle {

    private final Class<T> clazz;
    private EventBus eventBus;

    public ProducerVerticle(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void start() {
        eventBus = vertx.eventBus();
        eventBus.registerCodec(new BeanCodec<>(clazz));
    }

    public void publish(String topic, T msg) {
        eventBus.publish(topic, msg, new DeliveryOptions().setCodecName(clazz.getSimpleName()));
    }
}
