package cn.sinozg.applet.mq.vertx.handle;


import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.mq.joint.BaseTopicType;
import cn.sinozg.applet.mq.mq.MqProducer;
import cn.sinozg.applet.mq.vertx.VertxManager;
import cn.sinozg.applet.mq.vertx.verticle.ProducerVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.CountDownLatch;

/**
 * Vertx 模式下的 生产者
 * @Description
 * @Copyright Copyright (c) 2023
 * @author xieyubin
 * @since 2023-11-20 12:32:43
 */
public class VertxMqProducer<T> implements MqProducer<T> {

    private final ProducerVerticle<T> producerVerticle;

    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private static final Logger log = LoggerFactory.getLogger(VertxMqProducer.class);

    public VertxMqProducer(Class<T> clazz) {
        producerVerticle = new ProducerVerticle<>(clazz);
        VertxManager.instance().deployVerticle(producerVerticle, stringAsyncResult -> countDownLatch.countDown());
        //等待初始化完成
        try {
            countDownLatch.await();
        } catch (Exception e) {
            log.error("初始化 VertxMqProducer 失败！", e);
            throw new CavException("初始化 VertxMqProducer 失败！");
        }
    }

    @Override
    public void publish(BaseTopicType topic, T msg) {
        producerVerticle.publish(topic.topic(), msg);
    }

    @Override
    public void publish(String topic, T msg) {
        producerVerticle.publish(topic, msg);
    }
}
