/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.license.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;

/**
 * 证书生成参数
 * @Description
 * @Copyright Copyright (c) 2025
 * @author xyb
 * @since 2025-03-23 17:32:01
*/
public class LicenseCreateParams extends LicenseVerifyParams {

    /** 生效日期 */
    @Schema(description = "生效日期")
    private LocalDateTime issued;

    /** 失效日期 */
    @Schema(description = "失效日期")
    private LocalDateTime expiry;

    /** 用户类型 */
    @Schema(description = "用户类型")
    private String type;

    /** 用户数量 */
    @Schema(description = "用户类型")
    private Integer amount;

    /** 描述 */
    @Schema(description = "描述")
    private String desc;

    /** 服务器信息 */
    @Schema(description = "服务器信息")
    private LicenseCheckModel checkModel;

    /**
     * 获取 生效日期
     *
     * @return issued 生效日期
     */
    public LocalDateTime getIssued() {
        return this.issued;
    }

    /**
     * 设置 生效日期
     *
     * @param issued 生效日期
     */
    public void setIssued(LocalDateTime issued) {
        this.issued = issued;
    }

    /**
     * 获取 失效日期
     *
     * @return expiry 失效日期
     */
    public LocalDateTime getExpiry() {
        return this.expiry;
    }

    /**
     * 设置 失效日期
     *
     * @param expiry 失效日期
     */
    public void setExpiry(LocalDateTime expiry) {
        this.expiry = expiry;
    }

    /**
     * 获取 用户类型
     *
     * @return type 用户类型
     */
    public String getType() {
        return this.type;
    }

    /**
     * 设置 用户类型
     *
     * @param type 用户类型
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 获取 用户数量
     *
     * @return amount 用户数量
     */
    public Integer getAmount() {
        return this.amount;
    }

    /**
     * 设置 用户数量
     *
     * @param amount 用户数量
     */
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    /**
     * 获取 描述
     *
     * @return desc 描述
     */
    public String getDesc() {
        return this.desc;
    }

    /**
     * 设置 描述
     *
     * @param desc 描述
     */
    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 获取 服务器信息
     *
     * @return checkModel 服务器信息
     */
    public LicenseCheckModel getCheckModel() {
        return this.checkModel;
    }

    /**
     * 设置 服务器信息
     *
     * @param checkModel 服务器信息
     */
    public void setCheckModel(LicenseCheckModel checkModel) {
        this.checkModel = checkModel;
    }
}
