package cn.sinozg.applet.common.enums;

import java.time.Duration;

/**
 * 限流模式单位
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-07-14 11:30
 */
public enum RateLimiterUnit {
    /** 秒 */
    SECONDS {
        @Override
        public Duration duration(int value) {
            return Duration.ofSeconds(value);
        }
    },
    /** 分 */
    MINUTES {
        @Override
        public Duration duration(int value) {
            return Duration.ofMinutes(value);
        }
    },
    /** 时 */
    HOURS {
        @Override
        public Duration duration(int value) {
            return Duration.ofHours(value);
        }
    },
    /** 天 */
    DAYS {
        @Override
        public Duration duration(int value) {
            return Duration.ofDays(value);
        }
    };
    RateLimiterUnit(){
    }

    public abstract Duration duration(int value);
}
