package cn.sinozg.applet.common.annotation;

import cn.sinozg.applet.common.enums.RegexType;
import cn.sinozg.applet.common.serializer.RegexValidator;
import org.apache.commons.lang3.StringUtils;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 自定义正则表达式验证
 * @Author: xyb
 * @Description:
 * @Date: 2023-09-29 下午 04:33
 **/
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = {RegexValidator.class})
public @interface Regex {

    /** 错误提示 */
    String message() default StringUtils.EMPTY;
    /** 是否必填 */
    boolean required() default true;
    /** 验证类型 */
    RegexType type();

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
