/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.DateUtil;
import java.time.LocalDate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class IdCardUtil {
    private static final String REGEX = "([1|6][1-5]|2[1-3]|3[1-7]|4[1-6]|5[0-4]|71|81|82|83|90)([0-2][0-9]|[3-5][0-4]|90)([0-5|7-9][0-9])";
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final int LEN_15 = 15;
    private static final int LEN_18 = 18;
    private static final String DIGITAL_REGEX = "^[0-9]*$";

    private IdCardUtil() {
    }

    public static void checkIdCard(String idCardNum) {
        String msg = IdCardUtil.idCard(idCardNum);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new CavException("BIZ000100033");
        }
    }

    public static String idCard(String idCardNum) {
        if (StringUtils.isBlank((CharSequence)(idCardNum = StringUtils.trimToEmpty((String)idCardNum)))) {
            return "\u8eab\u4efd\u8bc1\u53f7\u7801\u4e3a\u7a7a";
        }
        int len = idCardNum.length();
        if (len != 18 && len != 15) {
            return "\u8eab\u4efd\u8bc1\u53f7\u7801\u5fc5\u987b\u662f18\u6216\u800515\u4f4d\uff01";
        }
        String idCardPre = StringUtils.substring((String)idCardNum, (int)0, (int)(len - 1));
        if (!idCardPre.matches(DIGITAL_REGEX)) {
            return "\u8eab\u4efd\u8bc1\u53f7\u7801\u9664\u6700\u540e\u4e00\u4f4d\u5916\u5fc5\u987b\u4e3a\u6570\u5b57\uff01";
        }
        if (len == 15) {
            idCardNum = IdCardUtil.idCard15To18(idCardNum);
        }
        return IdCardUtil.isIdCard(idCardNum);
    }

    public static String idCard15To18(String idCardNum) {
        if (StringUtils.isBlank((CharSequence)(idCardNum = StringUtils.trimToEmpty((String)idCardNum))) || idCardNum.length() != 15) {
            return "";
        }
        if (!idCardNum.matches(DIGITAL_REGEX)) {
            throw new RuntimeException("\u8eab\u4efd\u8bc1\u53f7\u7801\u9664\u6700\u540e\u4e00\u4f4d\u5916\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
        }
        String idCard17 = StringUtils.substring((String)idCardNum, (int)0, (int)6) + "19" + StringUtils.substring((String)idCardNum, (int)6);
        String powerCode = IdCardUtil.powerStr(idCard17);
        return idCard17 + powerCode;
    }

    private static String isIdCard(String idNm) {
        LocalDate ld;
        String ymd = StringUtils.substring((String)idNm, (int)6, (int)14);
        try {
            ld = DateUtil.parseDate(ymd, "yyyyMMdd");
            String newYmd = DateUtil.formatDate(ld, "yyyyMMdd");
            if (!newYmd.equals(ymd)) {
                return "\u8eab\u4efd\u8bc1\u51fa\u751f\u65e5\u671f\u4e0d\u6b63\u786e\uff01";
            }
        }
        catch (Exception e) {
            return "\u8eab\u4efd\u8bc1\u51fa\u751f\u65e5\u671f\u4e0d\u6b63\u786e\uff01";
        }
        LocalDate now = LocalDate.now();
        LocalDate bf = now.minusYears(150L);
        if (bf.isAfter(now) || ld.isBefore(bf)) {
            return "\u51fa\u751f\u65e5\u671f\u8d85\u51fa\u65e5\u671f\u8303\u56f4\uff01";
        }
        String pcc = StringUtils.substring((String)idNm, (int)0, (int)6);
        if (!Pattern.matches(REGEX, pcc)) {
            return "\u672a\u5b9a\u4e49\u7684\u884c\u653f\u533a\u5212\u4ee3\u7801\uff01";
        }
        String lastCode = StringUtils.substring((String)idNm, (int)17);
        String idNm17 = StringUtils.substring((String)idNm, (int)0, (int)17);
        String powerCode = IdCardUtil.powerStr(idNm17);
        if (!powerCode.equals(lastCode)) {
            return "\u975e\u6cd5\u7684\u8eab\u4efd\u8bc1\u53f7\u7801\uff01";
        }
        return "";
    }

    private static String powerStr(String nm) {
        int sum = 0;
        int j = 17;
        for (int i = 0; i < j; ++i) {
            sum += (nm.charAt(i) - 48) * POWER[i];
        }
        int t = sum % 11;
        int x = 2;
        int c = 90;
        if (t < x) {
            c = 49;
        } else if (t > x) {
            c = 60;
        }
        return Character.toString((char)(c - t));
    }
}

