package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.function.SupplierException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

import java.security.SecureRandom;

/**
 * 工具类 自己用
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-25 下午 12:38
 **/
public class TirsciUtil {
    private static final Logger log = LoggerFactory.getLogger(TirsciUtil.class);
    private static final SecureRandom RANDOM = new SecureRandom();
    private TirsciUtil(){
    }
    /**
     * 异常捕获起来
     * @param supplier 要执行的方法
     * @return 返回数据
     * @param <T> 类型
     */
    public static <T> T tryCatch (SupplierException<T> supplier){
        try {
            return supplier.get();
        } catch (Exception ignored) {
        }
        return null;
    }

    /**
     * <p>格式化文本, {} 表示占位符
     * <p>此方法只是简单将占位符 {} 按照顺序替换为参数
     * <p>如果想输出 {} 使用 \\转义 { 即可，如果想输出 {} 之前的 \ 使用双转义符 \\\\ 即可
     * <p>例：
     *  <pre> {@code
     *  // 通常使用 -> this is a for b
     * format("this is {} for {}", "a", "b")
     * // 转义{}：-> this is \{} for a
     * format("this is \\{} for {}", "a", "b")
     * // 转义\：：-> this is \a for b
     * format("this is \\\\{} for {}", "a", "b")
     * }</pre>
     * @param strPattern 文本模板，被替换的部分用 {} 表示
     * @param argArray   参数值
     * @return 格式化后的文本
     */
    public static String format(final String strPattern, final Object... argArray) {
        if (StringUtils.isEmpty(strPattern) || ArrayUtils.isEmpty(argArray)) {
            return strPattern;
        }
        FormattingTuple tuple = MessageFormatter.arrayFormat(strPattern, argArray);
        return tuple.getMessage();
    }

    /**
     * 随机整数 [0,bound)
     * @param bound 最大
     * @return 整数
     */
    public static int nextInt (int bound){
        return RANDOM.nextInt(bound);
    }
}