package cn.sinozg.applet.common.serializer;

import cn.sinozg.applet.common.annotation.Regex;
import cn.sinozg.applet.common.enums.RegexType;
import cn.sinozg.applet.common.utils.IdCardUtil;
import org.apache.commons.lang3.StringUtils;


import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 自定义验证注解实现
 * @Author: xyb
 * @Description:
 * @Date: 2023-09-29 下午 04:43
 **/
public class RegexValidator implements ConstraintValidator<Regex, String> {

    private Regex regex;

    @Override
    public void initialize(Regex annotation) {
        regex = annotation;
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        // 值为空
        if (StringUtils.isBlank(value)) {
            // 必填
            if (regex.required()) {
                setMessage(true, context);
            }
            return !regex.required();
        }
        Pattern pattern = Pattern.compile(regex.type().getRegexp());
        Matcher matcher = pattern.matcher(value);
        boolean result = matcher.matches();
        // 单独 再次校验身份证
        if (result && regex.type() == RegexType.ID_CARD) {
            result = StringUtils.isBlank(IdCardUtil.idCard(value));
        }
        // 返回枚举对应的错误信息
        if (!result) {
            setMessage(false, context);
        }
        return result;
    }

    private void setMessage(boolean required, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(regex.type().getMsg() + (required ? "不能为空！" : "格式不正确！"))
                .addConstraintViolation();
    }
}