package cn.sinozg.applet.common.enums;

import cn.sinozg.applet.common.utils.DateUtil;

/**
 * 锁的粒度
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2023
 * @since 2023-08-24 15:14
 */
public enum LockGranularityType {

    /** 秒 */
    SECOND(DateUtil.YYYYMMDDHHMMSS),
    /** 分 */
    MINUTE(DateUtil.YYYYMMDDHHMM),
    /** 时 */
    HOUR(DateUtil.YYYYMMDDHH),
    /** 天 */
    DAY(DateUtil.YYYYMMDD),
    ;
    /** 格式 **/
    private final String pattern;

    LockGranularityType(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return pattern;
    }
}
