package cn.sinozg.applet.common.core.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.collections4.CollectionUtils;

import java.util.List;


/**
* Tree Select树结构实体类
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 09:39
**/
public class TreeSelect {

    /** 节点ID */
    @Schema(description = "id")
    private String id;

    /** 其他参数 */
    @Schema(description = "其他参数")
    private String params;

    /** 节点名称 */
    @Schema(description = "名称")
    private String label;
    /** 国际化名称 */
    @JsonIgnore
    private I18nName jsonLabel;
    @Schema(description = "是否选中")
    private boolean checked = false;

    /** 父id */
    @Schema(description = "父id")
    private String parId;
    /** 层级 */
    @JsonIgnore
    private int level;

    /** 排序 */
    @JsonIgnore
    private int seqNo;
    /** 子节点 */
    @Schema(description = "子节点数据")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<? extends TreeSelect> children;

    public void setChecked(List<String> ids) {
        this.checked = CollectionUtils.isNotEmpty(ids) && ids.contains(id);
    }

    /**
     * 获取 节点ID
     *
     * @return id 节点ID
     */
    public String getId() {
        return this.id;
    }

    /**
     * 设置 节点ID
     *
     * @param id 节点ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取 其他参数
     *
     * @return params 其他参数
     */
    public String getParams() {
        return this.params;
    }

    /**
     * 设置 其他参数
     *
     * @param params 其他参数
     */
    public void setParams(String params) {
        this.params = params;
    }

    /**
     * 获取 节点名称
     *
     * @return label 节点名称
     */
    public String getLabel() {
        return this.label;
    }

    /**
     * 设置 节点名称
     *
     * @param label 节点名称
     */
    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * 获取 国际化名称
     *
     * @return jsonLabel 国际化名称
     */
    public I18nName getJsonLabel() {
        return this.jsonLabel;
    }

    /**
     * 设置 国际化名称
     *
     * @param jsonLabel 国际化名称
     */
    public void setJsonLabel(I18nName jsonLabel) {
        this.jsonLabel = jsonLabel;
    }

    /**
     * 获取 @Schema(description = "是否选中")
     *
     * @return checked @Schema(description = "是否选中")
     */
    public boolean isChecked() {
        return this.checked;
    }

    /**
     * 设置 @Schema(description = "是否选中")
     *
     * @param checked @Schema(description = "是否选中")
     */
    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    /**
     * 获取 父id
     *
     * @return parId 父id
     */
    public String getParId() {
        return this.parId;
    }

    /**
     * 设置 父id
     *
     * @param parId 父id
     */
    public void setParId(String parId) {
        this.parId = parId;
    }

    /**
     * 获取 层级
     *
     * @return level 层级
     */
    public int getLevel() {
        return this.level;
    }

    /**
     * 设置 层级
     *
     * @param level 层级
     */
    public void setLevel(int level) {
        this.level = level;
    }

    /**
     * 获取 排序
     *
     * @return seqNo 排序
     */
    public int getSeqNo() {
        return this.seqNo;
    }

    /**
     * 设置 排序
     *
     * @param seqNo 排序
     */
    public void setSeqNo(int seqNo) {
        this.seqNo = seqNo;
    }

    /**
     * 获取 子节点
     *
     * @return children 子节点
     */
    public List<? extends TreeSelect> getChildren() {
        return this.children;
    }

    /**
     * 设置 子节点
     *
     * @param children 子节点
     */
    public void setChildren(List<? extends TreeSelect> children) {
        this.children = children;
    }
}
