package cn.sinozg.applet.common.core.model;

import cn.sinozg.applet.common.enums.NodeType;

/**
 * json 节点信息
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2023
 * @since 2023-08-25 21:41
 */
public class JsonNodeInfo {
    /** 类型 **/
    private NodeType type;
    /** 值 **/
    private String value;

    /** 为数组的时候取的下标 为负数 则反过来取值 */
    private int index;

    public JsonNodeInfo(){
    }
    public JsonNodeInfo(int index, NodeType type){
        this.index = index;
        this.type = type;
    }
    public JsonNodeInfo(String value, NodeType type){
        this.value = value;
        this.type = type;
    }

    /**
     * 获取 类型
     *
     * @return type 类型
     */
    public NodeType getType() {
        return this.type;
    }

    /**
     * 设置 类型
     *
     * @param type 类型
     */
    public void setType(NodeType type) {
        this.type = type;
    }

    /**
     * 获取 值
     *
     * @return value 值
     */
    public String getValue() {
        return this.value;
    }

    /**
     * 设置 值
     *
     * @param value 值
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * 获取 为数组的时候取的下标 为负数 则反过来取值
     *
     * @return index 为数组的时候取的下标 为负数 则反过来取值
     */
    public int getIndex() {
        return this.index;
    }

    /**
     * 设置 为数组的时候取的下标 为负数 则反过来取值
     *
     * @param index 为数组的时候取的下标 为负数 则反过来取值
     */
    public void setIndex(int index) {
        this.index = index;
    }
}
