package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.constant.BaseConstants;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 实现一些基本算法
 * @Author: xyb
 * @Description:
 * @Date: 2023-05-11 下午 01:14
 **/
public class AlgoUtil {

    /** 栈 */
    private static final Deque<Object> DEQUE = new ArrayDeque<>();
    private AlgoUtil() {
    }
    /**
     * 全排列公式
     * <p> 就是从任意m里面取出n个数，每个数都是不一样的，可以重复的
     * <p> 实现的算法如下 m<sup>n</sup>
     * @param m 总数
     * @param n 要取出的数
     */
    public static List<List<Integer>> power(int m, int n){
        if (n > m) {
            return null;
        }
        List<Integer> list = numList(m);
        List<String> streamList = PojoUtil.toList(list, i -> i + BaseConstants.COMMA);
        Stream<String> stream = streamList.stream();
        for (int j = 1; j < n; j++) {
            stream = stream.flatMap(str -> streamList.stream().map(str::concat));
        }
        List<String> result = stream.collect(Collectors.toList());
        return PojoUtil.toList(result, r -> PojoUtil.toList(PojoUtil.singleToList(r), Integer::parseInt));
    }

    /**
     * 组合公式逻辑实现
     * <p> 实现的算法如下 C<sub>m</sub><sup>n</sup>
     * @param m 总数
     * @param n 要取出的数
     */
    public static List<List<Integer>> c(int m, int n){
        List<Integer> list = numList(m);
        return c(list, n);
    }



    /**
     * 组合公式逻辑实现 m为resources的size
     * <p> 实现的算法如下 C<sub>m</sub><sup style="margin-left:-10px">n</sup>
     * @param resources 要排列的数据
     * @param n 要取出的数量
     * @return 所有的情况
     * @param <T> 类型
     */
    public static <T> List<List<T>> c (List<T> resources, int n){
        if (CollectionUtils.isEmpty(resources)) {
            return null;
        }
        int m = resources.size();
        if (m < n || n < 0) {
            throw new RuntimeException("取出的数量必须最小为1，最大为当前资源数量！");
        }
        List<List<T>> result = new ArrayList<>();
        recursion(result, resources, m - n, 0);
        return result;
    }

    /**
     * 迭代实现组合排列的逻辑
     * @param result 返回的结果集
     * @param resources 要排列的数据集
     * @param curNum  当前值
     * @param indexNum 迭代的下标
     * @param <T> 数据类型
     */
    private static <T> void recursion (List<List<T>> result, List<T> resources, int curNum, int indexNum){
        int maxNum = resources.size();
        if (curNum == maxNum) {
            List<T> list = new ArrayList<>();
            DEQUE.forEach(c -> list.add(PojoUtil.cast(c)));
            result.add(list);
            return;
        }
        T temp;
        for (int i = indexNum; i < maxNum; i++) {
            temp = resources.get(i);
            if (!DEQUE.contains(temp)) {
                DEQUE.push(temp);
                recursion(result, resources, curNum + 1, i);
                DEQUE.pop();
            }
        }
    }

    private static List<Integer> numList(int m){
        List<Integer> list = new ArrayList<>();
        for (int i = 1; i < m + 1; i++) {
            list.add(i);
        }
        return list;
    }
}