package cn.sinozg.applet.common.constant;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * jackson 实例 web环境下初始化注入
 * 非web环境下 初始化
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-05 16:09
 */
public class OmConstants {
    private static final Logger LOG = LoggerFactory.getLogger(OmConstants.class);
    /** ObjectMapper */
    private static volatile ObjectMapper OM;

    /**
     * web方式注入
     * @param om 对象
     */
    public static void setOm(ObjectMapper om){
        if (OM == null) {
            OM = om;
        }
    }

    /**
     * 获取实例
     * @return 实例
     */
    public static ObjectMapper getOm() {
        if (OM == null) {
            synchronized (OmConstants.class) {
                if (OM == null) {
                    LOG.error("new 的对象。。。。。。");
                    OM = new ObjectMapper();
                }
            }
        }
        return OM;
    }
}
