/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class SnowFlake {
    private static final String DEF_STR = "jb_biz";
    private final long twepoch = 1640966400000L;
    private final long workerIdBits = 5L;
    private final long dataCenterIdBits = 5L;
    private final long maxWorkerId = 31L;
    private final long maxDataCenterId = 31L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long dataCenterIdShift = 17L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private final long workerId;
    private final long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static final SnowFlake ID_WORKER = new SnowFlake(SnowFlake.getWorkId(), SnowFlake.getDataCenterId());

    public SnowFlake(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("workerId can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("dataCenterId can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (this.lastTimestamp > timestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1640966400000L << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    private static Long getWorkId() {
        try {
            String hostAddress = Inet4Address.getLocalHost().getHostAddress();
            return SnowFlake.str2Long(hostAddress);
        }
        catch (UnknownHostException e) {
            return RandomUtils.nextLong((long)0L, (long)32L);
        }
    }

    private static Long getDataCenterId() {
        String hostName = StringUtils.defaultString((String)SystemUtils.getHostName(), (String)DEF_STR);
        return SnowFlake.str2Long(hostName);
    }

    private static Long str2Long(String input) {
        int[] points = StringUtils.toCodePoints((CharSequence)input);
        int sums = 0;
        for (int i : points) {
            sums += i;
        }
        return sums % 32;
    }

    public static synchronized String genId() {
        return String.valueOf(SnowFlake.geneId());
    }

    public static synchronized Long geneId() {
        return ID_WORKER.nextId();
    }
}

