/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.serializer;

import cn.sinozg.applet.common.annotation.UtcOut;
import cn.sinozg.applet.common.enums.DatePattern;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.TirsciUtil;
import cn.sinozg.applet.common.utils.UserUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.time.LocalDateTime;

public class UtcOutSerializer
extends JsonSerializer<LocalDateTime>
implements ContextualSerializer {
    private String pattern;

    public void serialize(LocalDateTime ldt, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        String timeStr = "";
        if (ldt != null) {
            String utc = UserUtil.utc();
            LocalDateTime utcLdt = DateUtil.ldtUtc((LocalDateTime)ldt, (String)utc);
            timeStr = DateUtil.formatDateTime((LocalDateTime)utcLdt, (String)this.pattern);
        }
        gen.writeObject((Object)timeStr);
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty property) throws JsonMappingException {
        UtcOut utc;
        if (property != null && LocalDateTime.class.isAssignableFrom(property.getType().getRawClass()) && (utc = (UtcOut)property.getAnnotation(UtcOut.class)) != null) {
            this.pattern = TirsciUtil.utcPattern((DatePattern)utc.pattern(), () -> UserUtil.user().getOther());
            return this;
        }
        return null;
    }
}

