package cn.sinozg.applet.common.annotation;

import cn.sinozg.applet.common.enums.LockGranularityType;
import org.apache.commons.lang3.StringUtils;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 分布式锁 基于redisson<p/>
 * 支持定时任务<p/>
 * 支持spEL的方式获取到参数作为key进行锁定
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2023
 * @since 2023-08-24 15:08
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RedissonLock {

    /** 为空，则锁方法，有值，锁对应的值，支持spEL表达式 */
    String key() default StringUtils.EMPTY;
    /** 等待多久（单位：秒） */
    int waitTime() default 10;

    /** 锁多久后自动释放（单位：秒） */
    int leaseTime() default 10;

    /** 是否为定时任务 */
    boolean scheduled() default false;

    /** 定时任务的时候，锁的粒度，即多久内执行一次，其他的都算重复 */
    LockGranularityType granularity() default LockGranularityType.SECOND;
}
