/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.customizer;

import cn.sinozg.applet.common.annotation.DictTrans;
import cn.sinozg.applet.common.annotation.EnumField;
import cn.sinozg.applet.common.core.model.DictDataVo;
import cn.sinozg.applet.common.enums.DictType;
import cn.sinozg.applet.common.utils.DictUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.StringUtil;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.PropertyCustomizer;
import org.springframework.stereotype.Component;

@Component
public class EnumFieldCustomizer
implements PropertyCustomizer {
    public static final Logger log = LoggerFactory.getLogger(EnumFieldCustomizer.class);

    public Schema<?> customize(Schema property, AnnotatedType type) {
        Object[] annotations = type.getCtxAnnotations();
        if (ArrayUtils.isNotEmpty((Object[])annotations)) {
            String enumInfo = null;
            for (Object a : annotations) {
                DictTrans e;
                if (a instanceof DictTrans) {
                    e = (DictTrans)a;
                    enumInfo = this.dictPair(e);
                    break;
                }
                if (!(a instanceof EnumField)) continue;
                e = (EnumField)a;
                try {
                    enumInfo = this.enumInfo((EnumField)e);
                }
                catch (Exception ex) {
                    log.error("\u83b7\u53d6\u679a\u4e3e\u503c\u9519\u8bef\uff01", (Throwable)ex);
                }
            }
            if (StringUtils.isNotBlank(enumInfo)) {
                if (StringUtils.isNotBlank((CharSequence)property.getDescription())) {
                    enumInfo = property.getDescription() + "<br/>" + enumInfo;
                }
                property.setDescription(enumInfo);
            }
        }
        return property;
    }

    private String enumInfo(EnumField ef) throws Exception {
        StringBuilder info = new StringBuilder("");
        Class clazz = ef.clazz();
        if (clazz.isEnum()) {
            Field key = clazz.getDeclaredField(ef.key());
            key.setAccessible(true);
            Field name = clazz.getDeclaredField(ef.name());
            name.setAccessible(true);
            T[] os = clazz.getEnumConstants();
            TreeMap<Object, Object> map = new TreeMap<Object, Object>();
            for (Object o : os) {
                map.put(PojoUtil.cast((Object)key.get(o)), PojoUtil.cast((Object)name.get(o)));
            }
            for (Map.Entry entry : map.entrySet()) {
                info.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append(" ");
            }
        }
        return this.wrapUp(info, false, false);
    }

    private String dictPair(DictTrans dict) {
        StringBuilder info = new StringBuilder("");
        DictType type = dict.type();
        boolean error = false;
        if (ArrayUtils.isNotEmpty((Object[])dict.pairs())) {
            for (String pair : dict.pairs()) {
                info.append(pair).append(" ");
            }
        } else {
            List dictList = DictUtil.getDictCache((DictType)type);
            if (CollectionUtils.isEmpty((Collection)dictList)) {
                info.append("\u6570\u636e\u5b57\u5178\u672a\u5b9a\u4e49\uff01 ");
                error = true;
            } else {
                for (DictDataVo d : dictList) {
                    info.append(d.getDictValue()).append(":").append(DictUtil.dictLabel((DictDataVo)d, (Locale)Locale.CHINA)).append(" ");
                }
            }
        }
        return this.wrapUp(info, error, true);
    }

    private String wrapUp(StringBuilder info, boolean error, boolean isDict) {
        String color = String.format("<span><font color=\"%s\">", error ? "red" : "green");
        info.insert(0, color);
        StringUtil.delLast((StringBuilder)info);
        info.append("</font></span>");
        if (isDict) {
            info.insert(0, "(");
            info.append(")");
        }
        return info.toString();
    }
}

