/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.customizer;

import cn.sinozg.applet.common.annotation.JsonField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.autoconfigure.SqlSessionFactoryBeanCustomizer;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Component
public class JsonFieldCustomizer
implements SqlSessionFactoryBeanCustomizer {
    @Resource
    private MybatisPlusProperties properties;
    private static final Logger log = LoggerFactory.getLogger(JsonFieldCustomizer.class);
    private static final ResourcePatternResolver RESOURCE_PATTERN_RESOLVER = new PathMatchingResourcePatternResolver();
    private static final MetadataReaderFactory METADATA_READER_FACTORY = new CachingMetadataReaderFactory();

    public void customize(MybatisSqlSessionFactoryBean factoryBean) {
        try {
            Set<Class<?>> classes = this.scanClasses(this.properties.getTypeAliasesPackage());
            HashSet mapType = new HashSet();
            TypeHandlerRegistry registry = factoryBean.getConfiguration().getTypeHandlerRegistry();
            classes.forEach(clazz -> {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers()) || field.getAnnotation(JsonField.class) == null || mapType.contains(field.getType())) continue;
                    mapType.add(field.getType());
                    registry.register(field.getType(), JacksonTypeHandler.class);
                }
            });
        }
        catch (Exception e) {
            log.error("JsonFieldCustomizer error", (Throwable)e);
        }
    }

    private Set<Class<?>> scanClasses(String packagePatterns) throws Exception {
        String[] packagePatternArray;
        Class assignableType = null;
        HashSet classes = new HashSet();
        for (String packagePattern : packagePatternArray = StringUtils.tokenizeToStringArray((String)packagePatterns, (String)",; \t\n")) {
            org.springframework.core.io.Resource[] resources;
            for (org.springframework.core.io.Resource resource : resources = RESOURCE_PATTERN_RESOLVER.getResources("classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packagePattern) + "/**/*.class")) {
                try {
                    boolean isEntity;
                    ClassMetadata classMetadata = METADATA_READER_FACTORY.getMetadataReader(resource).getClassMetadata();
                    Class clazz = Resources.classForName((String)classMetadata.getClassName());
                    boolean bl = isEntity = (assignableType == null || assignableType.isAssignableFrom(clazz)) && clazz.getAnnotation(TableName.class) != null;
                    if (!isEntity) continue;
                    classes.add(clazz);
                }
                catch (Throwable e) {
                    log.warn("Cannot load the '{}'. Cause by {}", (Object)resource, (Object)e.toString());
                }
            }
        }
        return classes;
    }
}

