package cn.sinozg.applet.common.serializer;

import cn.sinozg.applet.common.utils.StringUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;

import java.io.IOException;

/**
* 使用注解的方式修改图片显示地址
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 09:44
**/
public class PicUrlFieldSerializer extends JsonSerializer<String> implements ContextualSerializer {


    /**
     * 序列化图片id为图片地址
     * @param value 图片id
     * @param gen JsonGenerator
     * @param serializers 序列化对象
     * @throws IOException 异常
     */
    @Override
    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        // 写原值
        gen.writeObject(StringUtil.showUrl(value));
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        return this;
    }
}
