/**
 * Copyright (c) 2019, Sinlmao (888@1st.com).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.sinlmao.commons.network.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.*;

/**
 * <p> program: Sinlmao Commons Network Utils
 * <p> description: Fastjson工具类
 * <p> create: 2021-03-18 13:22
 *
 * @author Sinlmao
 * @since 1.6.0
 */
public class FastjsonUtil {

    public static Map<String, Object> toMap(JSONObject object) {
        Map<String, Object> map = new HashMap<>();
        Object value;
        String key;
        for (Iterator<?> it = object.keySet().iterator(); it.hasNext(); ) {
            key = (String) it.next();
            if (object.get(key) == null) {
                map.put(key, null);
            } else {
                try {
                    value = object.get(key);
                    if (value instanceof JSONArray) {
                        value = toList((JSONArray) value);
                    } else if (value instanceof JSONObject) {
                        value = toMap((JSONObject) value);
                    }
                    map.put(key, value);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return map;
    }

    public static List toList(JSONArray array) {
        List list = new ArrayList();
        Object value;
        for (int i = 0; i < array.size(); i++) {
            try {
                value = array.get(i);
                if (value instanceof JSONArray) {
                    value = toList((JSONArray) value);
                } else if (value instanceof JSONObject) {
                    value = toMap((JSONObject) value);
                }
                list.add(value);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}
