/**
 * Copyright (c) 2019, Sinlmao (888@1st.com).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.sinlmao.commons.network.tools;

import cn.sinlmao.commons.network.ssl.ProtocolSSLFactory;
import cn.sinlmao.commons.network.ssl.TrustAllCertificateContextBuilder;
import cn.sinlmao.commons.network.ssl.TrustAllHostnameVerifier;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;

import javax.net.ssl.*;

/**
 * <b>HttpsURLConnection SSL 证书忽略类</b>
 * <p>
 * 该类主要实现HttpsURLConnection SSL 证书忽略
 * <br /><br />
 * <b>HttpsURLConnection SSL certificate ignore class</b>
 * <p>
 * This class mainly implements HttpsURLConnection SSL certificate ignoring
 *
 * <p>program: Sinlmao Commons Network Utils
 * <p>description: HttpsURLConnection SSL 证书忽略类类
 * <p>create: 2019-08-21 11:11
 *
 * @author Sinlmao
 * @deprecated 1.5.0
 */
@Deprecated
public class IgnoreSSLTool {

    /**
     * 执行是否忽略HTTPS请求的SSL证书，必须在openConnection之前调用
     *
     * @param isIgnore 是否忽略
     * @throws NoSuchAlgorithmException NoSuchAlgorithmException
     * @throws KeyManagementException   KeyManagementException
     * @deprecated 1.5.0
     */
    @Deprecated
    private static void ignoreSSL(boolean isIgnore) throws NoSuchAlgorithmException, KeyManagementException {
        try {
            if (isIgnore) {
                HttpsURLConnection.setDefaultHostnameVerifier(new TrustAllHostnameVerifier());
                HttpsURLConnection.setDefaultSSLSocketFactory(TrustAllCertificateContextBuilder.build(ProtocolSSLFactory.PROTOCOL_DEFAULT));
            }
        } catch (Exception e) {
            if (e instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException) e;
            }
            if (e instanceof KeyManagementException) {
                throw (KeyManagementException) e;
            }
        }
    }
}
