/**
 * Copyright (c) 2019, Sinlmao (888@1st.com).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.sinlmao.commons.network.ssl;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

/**
 * <b>信任（忽略验证）所有HostName类</b>
 * <p>
 * 该类用于信任（忽略验证）所有HostName的场景
 * <br/><br/>
 * <b>Trust (ignore verification) all HostName classes</b>
 * <p>
 * This class is used in scenarios where all HostNames are trusted (ignored verification).
 *
 * <p> program: Sinlmao Commons Network Utils
 * <p> description: 信任（忽略验证）所有HostName类<
 * <p> create: 2020-06-18 11:31
 *
 * @author Sinlmao
 */
public class TrustAllHostnameVerifier implements HostnameVerifier {
    @Override
    public boolean verify(String hostname, SSLSession sslSession) {
        return true;
    }
}
