/**
 * Copyright (c) 2019, Sinlmao (888@1st.com).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.sinlmao.commons.network.soap;

/**
 * <p> program: Sinlmao Commons Network Utils
 * <p> description:
 * <p> create: 2020-06-22 14:08
 *
 * @author Sinlmao
 * @since 1.5.1
 */
public class ImSoapQname {

    private String value;
    private String prefix = "";
    private String namespace = "";
    private boolean inherit = true;

    public ImSoapQname(String value) {
        this.value = value;
    }

    public ImSoapQname(String value, boolean inherit) {
        this.value = value;
        this.inherit = inherit;
    }

    public ImSoapQname(String value, String prefix) {
        this.value = value;
        this.prefix = prefix;
    }

    public ImSoapQname(String value, String prefix, boolean inherit) {
        this.value = value;
        this.prefix = prefix;
        this.inherit = inherit;
    }

    public ImSoapQname(String value, String prefix, String namespace) {
        this.value = value;
        this.prefix = prefix;
        this.namespace = namespace;
    }

    public ImSoapQname(String value, String prefix, String namespace, boolean inherit) {
        this.value = value;
        this.prefix = prefix;
        this.namespace = namespace;
        this.inherit = inherit;
    }

    public String getValue() {
        return value;
    }

    public ImSoapQname setValue(String value) {
        this.value = value;
        return this;
    }

    public String getPrefix() {
        return prefix;
    }

    public ImSoapQname setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getNamespace() {
        return namespace;
    }

    public ImSoapQname setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public boolean isInherit() {
        return inherit;
    }

    public ImSoapQname setInherit(boolean inherit) {
        this.inherit = inherit;
        return this;
    }

    public boolean isQualified() {
        return !prefix.isEmpty() || !namespace.isEmpty();
    }
}
