/**
 * Copyright (c) 2019, Hangzhou Mingbo Technology Co., Ltd. (sinlmao@mingbo.tech).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.sinlmao.commons.network.soap;

import cn.sinlmao.commons.network.exception.DataTypeException;

import java.sql.Array;
import java.util.ArrayList;
import java.util.List;

/**
 * <p> description:
 * <p> program: Sinlmao Commons Network Utils
 * <p> create: 2020-06-21 13:58
 *
 * @author Sinlmao
 * @since 1.5.1
 */
public class ImHttpSoapElement {

    private ImSoapQname name;
    private Object value;

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    public ImHttpSoapElement(ImSoapQname name) {
        this.name = name;
    }

    public ImHttpSoapElement(String name) {
        this.name = new ImSoapQname(name);
    }

    public ImHttpSoapElement(String name, String value) {
        this.name = new ImSoapQname(name);
        this.value = value;
    }

    public ImHttpSoapElement(String name, ImHttpSoapElement value) {
        this.name = new ImSoapQname(name);
        this.value = value;
        if (value != null) {
            if (value.getName().isInherit()) {
                if (value.getName().getPrefix().isEmpty()) {
                    value.getName().setPrefix(this.name.getPrefix());
                }
                if (value.getName().getNamespace().isEmpty()) {
                    value.getName().setNamespace(this.name.getNamespace());
                }
            }
        }
    }

    public ImHttpSoapElement(String name, int value) {
        this.name = new ImSoapQname(name);
        this.value = value;
    }

    public ImHttpSoapElement(String name, double value) {
        this.name = new ImSoapQname(name);
        this.value = value;
    }

    public ImHttpSoapElement(String name, float value) {
        this.name = new ImSoapQname(name);
        this.value = value;
    }

    public ImHttpSoapElement(String name, long value) {
        this.name = new ImSoapQname(name);
        this.value = value;
    }

    public ImHttpSoapElement(String name, List<ImHttpSoapElement> value) {
        this.name = new ImSoapQname(name);
        this.value = value;
    }

    ////////////////////////////////////////////////////////////////////

    public ImHttpSoapElement(ImSoapQname name, String value) {
        this.name = name;
        this.value = value;
    }

    public ImHttpSoapElement(ImSoapQname name, ImHttpSoapElement value) {
        this.name = name;
        this.value = value;
        if (value != null) {
            if (value.getName().isInherit()) {
                if (value.getName().getPrefix().isEmpty()) {
                    value.getName().setPrefix(name.getPrefix());
                }
                if (value.getName().getNamespace().isEmpty()) {
                    value.getName().setNamespace(name.getNamespace());
                }
            }
        }
    }

    public ImHttpSoapElement(ImSoapQname name, int value) {
        this.name = name;
        this.value = value;
    }

    public ImHttpSoapElement(ImSoapQname name, double value) {
        this.name = name;
        this.value = value;
    }

    public ImHttpSoapElement(ImSoapQname name, float value) {
        this.name = name;
        this.value = value;
    }

    public ImHttpSoapElement(ImSoapQname name, long value) {
        this.name = name;
        this.value = value;
    }

    public ImHttpSoapElement(ImSoapQname name, List<ImHttpSoapElement> value) {
        this.name = name;
        this.value = value;
    }

    ////////////////////////////////////////////////////////////////////

    public ImHttpSoapElement(String name, String value, String prefix) {
        this.name = new ImSoapQname(name, prefix);
        this.value = value;
    }

    public ImHttpSoapElement(String name, ImHttpSoapElement value, String prefix) {
        this.name = new ImSoapQname(name, prefix);
        this.value = value;
        if (value != null) {
            if (value.getName().isInherit()) {
                if (value.getName().getPrefix().isEmpty()) {
                    value.getName().setPrefix(this.name.getPrefix());
                }
                if (value.getName().getNamespace().isEmpty()) {
                    value.getName().setNamespace(this.name.getNamespace());
                }
            }
        }
    }

    public ImHttpSoapElement(String name, int value, String prefix) {
        this.name = new ImSoapQname(name, prefix);
        this.value = value;
    }

    public ImHttpSoapElement(String name, double value, String prefix) {
        this.name = new ImSoapQname(name, prefix);
        this.value = value;
    }

    public ImHttpSoapElement(String name, float value, String prefix) {
        this.name = new ImSoapQname(name, prefix);
        this.value = value;
    }

    public ImHttpSoapElement(String name, long value, String prefix) {
        this.name = new ImSoapQname(name, prefix);
        this.value = value;
    }

    public ImHttpSoapElement(String name, List<ImHttpSoapElement> value, String prefix) {
        this.name = new ImSoapQname(name, prefix);
        this.value = value;
    }

    ////////////////////////////////////////////////////////////////////

    public ImHttpSoapElement(String name, String value, String prefix, String namespace) {
        this.name = new ImSoapQname(name, prefix, namespace);
        this.value = value;
    }

    public ImHttpSoapElement(String name, ImHttpSoapElement value, String prefix, String namespace) {
        this.name = new ImSoapQname(name, prefix, namespace);
        this.value = value;
        if (value != null) {
            if (value.getName().isInherit()) {
                if (value.getName().getPrefix().isEmpty()) {
                    value.getName().setPrefix(this.name.getPrefix());
                }
                if (value.getName().getNamespace().isEmpty()) {
                    value.getName().setNamespace(this.name.getNamespace());
                }
            }
        }
    }

    public ImHttpSoapElement(String name, int value, String prefix, String namespace) {
        this.name = new ImSoapQname(name, prefix, namespace);
        this.value = value;
    }

    public ImHttpSoapElement(String name, double value, String prefix, String namespace) {
        this.name = new ImSoapQname(name, prefix, namespace);
        this.value = value;
    }

    public ImHttpSoapElement(String name, float value, String prefix, String namespace) {
        this.name = new ImSoapQname(name, prefix, namespace);
        this.value = value;
    }

    public ImHttpSoapElement(String name, long value, String prefix, String namespace) {
        this.name = new ImSoapQname(name, prefix, namespace);
        this.value = value;
    }

    public ImHttpSoapElement(String name, List<ImHttpSoapElement> value, String prefix, String namespace) {
        this.name = new ImSoapQname(name, prefix, namespace);
        this.value = value;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    public ImSoapQname getName() {
        return name;
    }

    public ImHttpSoapElement setName(ImSoapQname name) {
        this.name = name;
        return this;
    }

    public Object getValue() {
        return value;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    public ImHttpSoapElement setValue(String value) {
        this.value = value;
        return this;
    }

    public ImHttpSoapElement setValue(ImHttpSoapElement value) {
        this.value = value;
        if (value != null) {
            if (value.getName().isInherit()) {
                if (value.getName().getPrefix().isEmpty()) {
                    value.getName().setPrefix(name.getPrefix());
                }
                if (value.getName().getNamespace().isEmpty()) {
                    value.getName().setNamespace(name.getNamespace());
                }
            }
        }
        return this;
    }

    public ImHttpSoapElement setValue(int value) {
        this.value = value;
        return this;
    }

    public ImHttpSoapElement setValue(float value) {
        this.value = value;
        return this;
    }

    public ImHttpSoapElement setValue(double value) {
        this.value = value;
        return this;
    }

    public ImHttpSoapElement setValue(long value) {
        this.value = value;
        return this;
    }

    public ImHttpSoapElement setValue(Object value) {
        if (value instanceof ImHttpSoapElement
                || value instanceof String
                || value instanceof Integer
                || value instanceof Double
                || value instanceof Float
                || value instanceof Long) {
            this.value = value;
        } else {
            throw new DataTypeException(DataTypeException.DataTypeUnSupport);
        }
        return this;
    }

    public ImHttpSoapElement setValue(List<ImHttpSoapElement> value) {
        this.value = value;
        return this;
    }

    public ImHttpSoapElement appendValue(Object child) {
        return appendValue(child.getClass().getSimpleName().toLowerCase(), child);
    }

    public ImHttpSoapElement appendValue(String name, Object child) {
        if (child != null) {
            if (child instanceof ImHttpSoapElement
                    || child instanceof String
                    || child instanceof Integer
                    || child instanceof Double
                    || child instanceof Float
                    || child instanceof Long) {
                if (child instanceof ImHttpSoapElement) {
                    return appendValue((ImHttpSoapElement) child);
                } else {
                    ImHttpSoapElement _element = new ImHttpSoapElement(name);
                    _element.setValue(child);
                    return appendValue(_element);
                }
            } else {
                throw new DataTypeException(DataTypeException.DataTypeUnSupport);
            }
        }
        return this;
    }

    @SuppressWarnings("unchecked")
    public ImHttpSoapElement appendValue(ImHttpSoapElement child) {
        if (child != null) {
            if (!(value instanceof List)) {
                List<ImHttpSoapElement> _value = new ArrayList<>();
                if (value != null) {
                    if (value instanceof ImHttpSoapElement) {
                        _value.add((ImHttpSoapElement) value);
                    } else {
                        ImHttpSoapElement _element = new ImHttpSoapElement(new ImSoapQname(value.getClass().getSimpleName().toLowerCase(), name.getPrefix(), name.getNamespace()));
                        _element.setValue(value);
                        _value.add(_element);
                    }
                }
                value = _value;
            }
            if (child.getName().isInherit()) {
                if (child.getName().getPrefix().isEmpty()) {
                    child.getName().setPrefix(name.getPrefix());
                }
                if (child.getName().getNamespace().isEmpty()) {
                    child.getName().setNamespace(name.getNamespace());
                }
            }
            ((List<ImHttpSoapElement>) value).add(child);
        }
        return this;
    }
}
