/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JacksonUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JacksonUtil() {
    }

    public static ObjectMapper getInstance() {
        return objectMapper;
    }

    public static String toJSONString(Object obj) throws JsonProcessingException {
        return objectMapper.writeValueAsString(obj);
    }

    public static String toJSONStringIgnoreNull(Object obj) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper.writeValueAsString(obj);
    }

    public static <T> T toJavaObject(String json, Class<T> clazz) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        return (T)mapper.readValue(json, clazz);
    }

    public static Map toMap(String json) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return (Map)mapper.readValue(json, Map.class);
    }

    public static <T> Map<String, T> toMap(String json, Class<T> clazz) throws JsonProcessingException {
        Map map = (Map)objectMapper.readValue(json, new TypeReference<Map<String, Map<String, T>>>(){});
        HashMap result = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey(), JacksonUtil.mapToBean((Map)entry.getValue(), clazz));
        }
        return result;
    }

    public static Map<String, Object> toMapNeedDeeply(String json) throws JsonProcessingException {
        return JacksonUtil.toMapRecursion(json, objectMapper);
    }

    private static List toList(String json, ObjectMapper mapper) throws JsonProcessingException {
        if (json == null) {
            return null;
        }
        List list = (List)mapper.readValue(json, List.class);
        for (Object obj : list) {
            if (!(obj instanceof String)) continue;
            String str = (String)obj;
            if (str.startsWith("[")) {
                obj = JacksonUtil.toList(str, mapper);
                continue;
            }
            if (!obj.toString().startsWith("{")) continue;
            obj = JacksonUtil.toMapRecursion(str, mapper);
        }
        return list;
    }

    private static Map<String, Object> toMapRecursion(String json, ObjectMapper mapper) throws JsonProcessingException {
        if (json == null) {
            return null;
        }
        Map map = (Map)mapper.readValue(json, Map.class);
        for (Map.Entry entry : map.entrySet()) {
            Object obj = entry.getValue();
            if (!(obj instanceof String)) continue;
            String str = (String)obj;
            if (str.startsWith("[")) {
                List list = JacksonUtil.toList(str, mapper);
                map.put(entry.getKey(), list);
                continue;
            }
            if (!str.startsWith("{")) continue;
            Map<String, Object> mapRecursion = JacksonUtil.toMapRecursion(str, mapper);
            map.put(entry.getKey(), mapRecursion);
        }
        return map;
    }

    public static <T> List<T> toList(String jsonArray, Class<T> clazz) throws JsonProcessingException {
        JavaType javaType = JacksonUtil.getCollectionType(ArrayList.class, clazz);
        return (List)objectMapper.readValue(jsonArray, javaType);
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static <T> T mapToBean(Map map, Class<T> clazz) {
        return (T)objectMapper.convertValue((Object)map, clazz);
    }

    public static String mapToJSON(Map map) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)map);
    }

    public static <T> T objectToAnother(Object src, Class<T> clazz) {
        return (T)objectMapper.convertValue(src, clazz);
    }
}

