/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentUtil {
    public static Document buildeDocument() {
        try {
            return DocumentUtil.newBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Document newXMLDocument(Node node) {
        Document doc = DocumentUtil.buildeDocument();
        doc.appendChild(doc.importNode(node, true));
        return doc;
    }

    public static DocumentBuilder newBuilder() throws ParserConfigurationException {
        return DocumentUtil.newBuilderFactory().newDocumentBuilder();
    }

    public static DocumentBuilderFactory newBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory;
    }

    public static Document parseDocument(String xml) {
        if (xml == null) {
            throw new IllegalArgumentException();
        }
        try {
            return DocumentUtil.newBuilder().parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Document parseDocument(InputStream input) {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        try {
            return DocumentUtil.newBuilder().parse(input);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Document loadDocumentFromFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("\u672a\u6307\u5b9a\u6587\u4ef6\u540d\u53ca\u5176\u7269\u7406\u8def\u5f84\uff01");
        }
        try {
            return DocumentUtil.newBuilder().parse(new File(fileName));
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("\u76ee\u6807\u6587\u4ef6\uff08" + fileName + "\uff09\u4e0d\u80fd\u88ab\u6b63\u786e\u89e3\u6790\u4e3aXML\uff01" + e.getMessage());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("\u4e0d\u80fd\u83b7\u53d6\u76ee\u6807\u6587\u4ef6\uff08" + fileName + "\uff09\uff01" + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String toString(Document document) {
        return DocumentUtil.toString(document, StandardCharsets.UTF_8.name(), true);
    }

    public static String toString(Document document, String charset) {
        return DocumentUtil.toString(document, charset, true);
    }

    public static String toString(Document document, String charset, boolean indent) {
        String result = null;
        if (document != null) {
            StringWriter strWtr = new StringWriter();
            StreamResult strResult = new StreamResult(strWtr);
            try {
                Transformer transformer = DocumentUtil.newTransformer(charset, indent);
                transformer.transform(new DOMSource(document.getDocumentElement()), strResult);
            }
            catch (Exception e) {
                System.err.println("XML.toString(Document): " + e);
            }
            result = strResult.getWriter().toString();
            try {
                strWtr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String toNodeString(Node node) {
        return DocumentUtil.toNodeString(node, StandardCharsets.UTF_8.name(), true);
    }

    public static String toNodeString(Node node, String charset) {
        return DocumentUtil.toNodeString(node, charset, true);
    }

    public static String toNodeString(Node node, String charset, boolean indent) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        Transformer transformer = DocumentUtil.newTransformer(charset, indent);
        try {
            StringWriter sw = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Transformer newTransformer(String charset, boolean indent) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            Properties properties = transformer.getOutputProperties();
            properties.setProperty("encoding", charset);
            properties.setProperty("method", "xml");
            properties.setProperty("version", "1.0");
            if (indent) {
                properties.setProperty("indent", "yes");
                properties.setProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            }
            transformer.setOutputProperties(properties);
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

