/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.ssl;

import cn.sinlmao.commons.network.ssl.ProtocolSSLFactory;
import cn.sinlmao.commons.network.ssl.TrustAllCertificateManager;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class TrustAllCertificateContextBuilder {
    public static SSLSocketFactory build(String protocol) throws Exception {
        return TrustAllCertificateContextBuilder.build(protocol, null, new SecureRandom());
    }

    public static SSLSocketFactory build(KeyManager[] keyManagers) throws Exception {
        return TrustAllCertificateContextBuilder.build("TLS", keyManagers, null);
    }

    public static SSLSocketFactory build(String protocol, KeyManager[] keyManagers) throws Exception {
        return TrustAllCertificateContextBuilder.build(protocol, keyManagers, null);
    }

    public static SSLSocketFactory build(String protocol, KeyManager[] keyManagers, SecureRandom secureRandom) throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllCertificateManager()};
        return ProtocolSSLFactory.getInstance(keyManagers, trustAllCerts, secureRandom);
    }
}

