/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.soap;

import cn.sinlmao.commons.network.http.ImCharset;
import cn.sinlmao.commons.network.http.ImRequest;
import cn.sinlmao.commons.network.soap.ImHttpSoapClient;
import cn.sinlmao.commons.network.soap.ImHttpSoapElement;
import cn.sinlmao.commons.network.soap.ImSoapVersion;
import cn.sinlmao.commons.network.utils.DocumentUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;

public class ImHttpSoapRequest {
    private String url;
    private String prefix = "";
    private String elementPrefix = "";
    private String elementNamespace = "";
    private ImSoapVersion version = ImSoapVersion.v_1_2;
    private ImCharset charset = ImCharset.UTF_8;
    private final Map<String, ImHttpSoapElement> bodyElements = new HashMap<String, ImHttpSoapElement>();
    private final Map<String, ImHttpSoapElement> headerElements = new HashMap<String, ImHttpSoapElement>();
    private final ImRequest request;

    public ImHttpSoapRequest(String url) {
        this.url = url;
        this.request = new ImRequest(url);
    }

    public ImHttpSoapRequest(String url, String elementPrefix, String elementNamespace, ImHttpSoapElement bodyElement) {
        this.url = url;
        this.elementPrefix = elementPrefix;
        this.elementNamespace = elementNamespace;
        this.bodyElements.put(bodyElement.getName().getValue(), bodyElement);
        this.request = new ImRequest(url);
    }

    public ImHttpSoapRequest addBodyElement(ImHttpSoapElement element) {
        this.appendElement(element, this.bodyElements);
        return this;
    }

    public Map<String, ImHttpSoapElement> getBodyElements() {
        return this.bodyElements;
    }

    public ImHttpSoapElement getBodyElement(String name) {
        if (!this.bodyElements.containsKey(name)) {
            return null;
        }
        return this.bodyElements.get(name);
    }

    public ImHttpSoapRequest addHeaderElement(ImHttpSoapElement element) {
        this.appendElement(element, this.headerElements);
        return this;
    }

    public Map<String, ImHttpSoapElement> getHeaderElements() {
        return this.headerElements;
    }

    public ImHttpSoapElement getHeaderElement(String name) {
        if (!this.headerElements.containsKey(name)) {
            return null;
        }
        return this.headerElements.get(name);
    }

    public ImHttpSoapRequest addRequestHeader(String name, String value) {
        this.request.addHeader(name, value);
        return this;
    }

    public ImHttpSoapRequest addRequestHeader(Map<String, String> headers) {
        this.request.addHeader(headers);
        return this;
    }

    @Deprecated
    public ImHttpSoapRequest addRequestHeader(JSONObject headers) {
        this.request.addHeader(headers);
        return this;
    }

    public ImHttpSoapRequest setRequestHeader(String name, String value) {
        this.request.setHeader(name, value);
        return this;
    }

    public ImHttpSoapRequest setRequestHeader(Map<String, String> headers) {
        this.request.setHeader(headers);
        return this;
    }

    @Deprecated
    public ImHttpSoapRequest setRequestHeader(JSONObject headers) {
        this.request.setHeader(headers);
        return this;
    }

    public ImHttpSoapRequest enableProxyServer(int port) {
        this.request.enableProxyServer(port);
        return this;
    }

    public ImHttpSoapRequest enableProxyServer(String host, int port) {
        this.request.enableProxyServer(host, port);
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public ImHttpSoapRequest setUrl(String url) {
        this.url = url;
        this.request.setUrl(url);
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ImHttpSoapRequest setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getElementPrefix() {
        return this.elementPrefix;
    }

    public ImHttpSoapRequest setElementPrefix(String elementPrefix) {
        this.elementPrefix = elementPrefix;
        return this;
    }

    public ImHttpSoapRequest setElementNamespace(String elementNamespace) {
        this.elementNamespace = elementNamespace;
        return this;
    }

    public ImHttpSoapRequest setElementNamespace(String elementPrefix, String elementNamespace) {
        this.elementPrefix = elementPrefix;
        this.elementNamespace = elementNamespace;
        return this;
    }

    public String getElementNamespace() {
        return this.elementNamespace;
    }

    public ImSoapVersion getVersion() {
        return this.version;
    }

    public ImHttpSoapRequest setVersion(ImSoapVersion version) {
        this.version = version;
        return this;
    }

    public ImCharset getCharset() {
        return this.charset;
    }

    public ImHttpSoapRequest setCharset(ImCharset charset) {
        this.charset = charset;
        this.request.setCharset(charset);
        return this;
    }

    public ImRequest getRequest() {
        return this.request;
    }

    private void appendElement(ImHttpSoapElement element, Map<String, ImHttpSoapElement> elements) {
        if (element != null) {
            if (element.getName().isInherit()) {
                if (element.getName().getPrefix().isEmpty()) {
                    element.getName().setPrefix(this.elementPrefix);
                }
                if (element.getName().getNamespace().isEmpty()) {
                    element.getName().setNamespace(this.elementNamespace);
                }
            }
            elements.put(element.getName().getValue(), element);
        }
    }

    public Document getMessageDataToDocument() {
        return ImHttpSoapClient.resolve(this);
    }

    public String getMessageDataToString() {
        return DocumentUtil.toString(ImHttpSoapClient.resolve(this));
    }
}

