/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.soap;

import cn.sinlmao.commons.network.http.ImContentType;
import cn.sinlmao.commons.network.http.ImHttpClient;
import cn.sinlmao.commons.network.http.ImMethod;
import cn.sinlmao.commons.network.http.ImRequest;
import cn.sinlmao.commons.network.http.ImResponse;
import cn.sinlmao.commons.network.soap.ImHttpSoapElement;
import cn.sinlmao.commons.network.soap.ImHttpSoapRequest;
import cn.sinlmao.commons.network.soap.ImSoapQname;
import cn.sinlmao.commons.network.soap.ImSoapVersion;
import cn.sinlmao.commons.network.utils.DocumentUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ImHttpSoapClient {
    public static ImResponse soap(ImHttpSoapRequest request) throws Exception {
        Document document = ImHttpSoapClient.resolve(request);
        ImRequest imRequest = request.getRequest();
        imRequest.setMethod(ImMethod.POST);
        imRequest.setInputData(DocumentUtil.toString(document, imRequest.getCharset(), false));
        if (request.getVersion() == ImSoapVersion.v_1_1) {
            imRequest.setContentType(ImContentType.SOAP_1_1);
        }
        if (request.getVersion() == ImSoapVersion.v_1_2) {
            imRequest.setContentType(ImContentType.SOAP_1_2);
        }
        return ImHttpClient.send(imRequest);
    }

    public static Document resolve(ImHttpSoapRequest request) {
        Collection<ImHttpSoapElement> childElements;
        Document document = DocumentUtil.buildeDocument();
        Element envelopeElement = document.createElement(ImHttpSoapClient.getTagName("Envelope", request.getPrefix(), request.getVersion(), true));
        envelopeElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        envelopeElement.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        if (request.getPrefix().isEmpty()) {
            if (request.getVersion() == ImSoapVersion.v_1_1) {
                envelopeElement.setAttribute("xmlns:SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
            }
            if (request.getVersion() == ImSoapVersion.v_1_2) {
                envelopeElement.setAttribute("xmlns:env", "http://www.w3.org/2003/05/soap-envelope");
            }
        } else {
            if (request.getVersion() == ImSoapVersion.v_1_1) {
                envelopeElement.setAttribute("xmlns:" + request.getPrefix(), "http://schemas.xmlsoap.org/soap/envelope/");
            }
            if (request.getVersion() == ImSoapVersion.v_1_2) {
                envelopeElement.setAttribute("xmlns:" + request.getPrefix(), "http://www.w3.org/2003/05/soap-envelope");
            }
        }
        if (!request.getElementPrefix().isEmpty() && !request.getElementNamespace().isEmpty()) {
            envelopeElement.setAttribute(ImHttpSoapClient.getXmlnsName(request.getElementPrefix()), request.getElementNamespace());
        }
        document.appendChild(envelopeElement);
        ImSoapQname elementQname = new ImSoapQname(envelopeElement.getTagName(), request.getElementPrefix(), request.getElementNamespace());
        Map<String, ImHttpSoapElement> headerElements = request.getHeaderElements();
        if (headerElements.size() > 0) {
            Element headerElement = document.createElement(ImHttpSoapClient.getTagName("Header", request.getPrefix(), request.getVersion(), true));
            childElements = headerElements.values();
            for (ImHttpSoapElement childElement : childElements) {
                headerElement.appendChild(ImHttpSoapClient.resolveElement(childElement, document, request, envelopeElement, childElement.getName().isQualified() ? childElement.getName() : elementQname));
            }
            envelopeElement.appendChild(headerElement);
        }
        Element bodyElement = document.createElement(ImHttpSoapClient.getTagName("Body", request.getPrefix(), request.getVersion(), true));
        envelopeElement.appendChild(bodyElement);
        if (request.getBodyElements().size() > 0) {
            childElements = request.getBodyElements().values();
            for (ImHttpSoapElement childElement : childElements) {
                bodyElement.appendChild(ImHttpSoapClient.resolveElement(childElement, document, request, envelopeElement, childElement.getName().isQualified() ? childElement.getName() : elementQname));
            }
        }
        return document;
    }

    public static Element resolveElement(ImHttpSoapElement soapElement, Document document, ImHttpSoapRequest request, Element envelopeElement, ImSoapQname qname) {
        String prefix;
        String string = soapElement.getName().getPrefix().isEmpty() ? (soapElement.getName().isInherit() ? qname.getPrefix() : "") : (prefix = soapElement.getName().getPrefix());
        String namespace = soapElement.getName().getNamespace().isEmpty() ? (soapElement.getName().isInherit() ? qname.getNamespace() : "") : soapElement.getName().getNamespace();
        Element element = document.createElement(ImHttpSoapClient.getTagName(soapElement.getName().getValue(), prefix, request.getVersion()));
        element.setAttribute(ImHttpSoapClient.getXmlnsName(prefix), namespace);
        if (!soapElement.getName().getPrefix().isEmpty() && soapElement.getName().getNamespace().equals(request.getElementNamespace())) {
            envelopeElement.setAttribute(ImHttpSoapClient.getXmlnsName(soapElement.getName().getPrefix()), soapElement.getName().getNamespace());
        }
        if (soapElement.getValue() instanceof ImHttpSoapElement) {
            element.appendChild(ImHttpSoapClient.resolveElement((ImHttpSoapElement)soapElement.getValue(), document, request, envelopeElement, soapElement.getName().isQualified() ? soapElement.getName() : qname));
        } else if (soapElement.getValue() instanceof List) {
            List childValues = (List)soapElement.getValue();
            Iterator iterator = childValues.iterator();
            while (iterator.hasNext()) {
                ImHttpSoapElement childValue;
                element.appendChild(ImHttpSoapClient.resolveElement(childValue, document, request, envelopeElement, (childValue = (ImHttpSoapElement)iterator.next()).getName().isQualified() ? childValue.getName() : qname));
            }
        } else if (soapElement.getValue() != null) {
            element.setTextContent(soapElement.getValue().toString());
        }
        return element;
    }

    private static String getXmlnsName() {
        return ImHttpSoapClient.getXmlnsName("");
    }

    private static String getXmlnsName(String prefix) {
        if (prefix.isEmpty()) {
            return "xmlns";
        }
        return "xmlns:" + prefix;
    }

    private static String getTagName(String name, String prefix, ImSoapVersion version) {
        return ImHttpSoapClient.getTagName(name, prefix, version, false);
    }

    private static String getTagName(String name, String prefix, ImSoapVersion version, boolean isDefault) {
        if (prefix != null && !prefix.isEmpty()) {
            return prefix + ":" + name;
        }
        if (isDefault) {
            String default_prefix = "env:";
            if (version == ImSoapVersion.v_1_1) {
                default_prefix = "SOAP-ENV:";
            }
            return default_prefix + name;
        }
        return name;
    }
}

