/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.http;

import cn.sinlmao.commons.network.callback.ImSessionCallback;
import cn.sinlmao.commons.network.utils.FastjsonUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ImSession {
    private boolean needAuthentication = false;
    private boolean autoAuthentication = false;
    private int autoAuthenticationTryCount = 3;
    private ImSessionCallback callback;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> cookies = new HashMap<String, String>();
    private Map<String, Object> extras = new HashMap<String, Object>();
    protected boolean ExecCallbackNow = false;

    public ImSession setNeedAuthentication(boolean needAuthentication) {
        this.needAuthentication = needAuthentication;
        return this;
    }

    public boolean isNeedAuthentication() {
        return this.needAuthentication;
    }

    public ImSession setAutoAuthentication(boolean autoAuthentication) {
        this.autoAuthentication = autoAuthentication;
        return this;
    }

    public boolean isAutoAuthentication() {
        return this.autoAuthentication;
    }

    public ImSession setAutoAuthenticationTryCount(int autoAuthenticationTryCount) {
        if (autoAuthenticationTryCount < 1) {
            autoAuthenticationTryCount = 1;
        }
        if (autoAuthenticationTryCount > 5) {
            autoAuthenticationTryCount = 5;
        }
        this.autoAuthenticationTryCount = autoAuthenticationTryCount;
        return this;
    }

    public int getAutoAuthenticationTryCount() {
        return this.autoAuthenticationTryCount;
    }

    public void setCallback(ImSessionCallback callback) {
        this.callback = callback;
    }

    public ImSession addHeader(String name, String value) {
        if (!this.headers.containsKey(name)) {
            this.headers.put(name, value);
        }
        return this;
    }

    public ImSession addHeader(Map<String, String> headers) {
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                this.addHeader(key, headers.get(key));
            }
        }
        return this;
    }

    @Deprecated
    public ImSession addHeader(JSONObject headers) {
        Map<String, Object> _headers = FastjsonUtil.toMap(headers);
        if (_headers != null && _headers.size() > 0) {
            for (String key : _headers.keySet()) {
                this.addHeader(key, _headers.get(key).toString());
            }
        }
        return this;
    }

    public ImSession setHeader(String name, String value) {
        if (this.headers.containsKey(name)) {
            this.headers.remove(name);
        }
        this.headers.put(name, value);
        return this;
    }

    @Deprecated
    public ImSession setHeader(JSONObject headers) {
        Map<String, Object> _headers = FastjsonUtil.toMap(headers);
        if (_headers != null && _headers.size() > 0) {
            for (String key : _headers.keySet()) {
                this.setHeader(key, _headers.get(key).toString());
            }
        }
        return this;
    }

    public ImSession setHeader(Map<String, String> headers) {
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                this.setHeader(key, headers.get(key));
            }
        }
        return this;
    }

    public ImSession addCookie(String name, String value) {
        if (!this.cookies.containsKey(name)) {
            this.cookies.put(name, value);
        }
        return this;
    }

    public ImSession addCookie(Map<String, String> cookies) {
        if (cookies != null && cookies.size() > 0) {
            for (String key : cookies.keySet()) {
                this.addCookie(key, cookies.get(key));
            }
        }
        return this;
    }

    @Deprecated
    public ImSession addCookie(JSONObject cookies) {
        Map<String, Object> _cookies = FastjsonUtil.toMap(cookies);
        if (_cookies != null && _cookies.size() > 0) {
            for (String key : _cookies.keySet()) {
                this.addCookie(key, _cookies.get(key).toString());
            }
        }
        return this;
    }

    public ImSession setCookie(String name, String value) {
        if (this.cookies.containsKey(name)) {
            this.cookies.remove(name);
        }
        this.cookies.put(name, value);
        return this;
    }

    public ImSession setCookie(Map<String, String> cookies) {
        if (cookies != null && cookies.size() > 0) {
            for (String key : cookies.keySet()) {
                this.setCookie(key, cookies.get(key));
            }
        }
        return this;
    }

    @Deprecated
    public ImSession setCookie(JSONObject cookies) {
        Map<String, Object> _cookies = FastjsonUtil.toMap(cookies);
        if (cookies != null && _cookies.size() > 0) {
            for (String key : _cookies.keySet()) {
                this.setCookie(key, _cookies.get(key).toString());
            }
        }
        return this;
    }

    public ImSession addExtra(String name, Object value) {
        if (!this.extras.containsKey(name)) {
            this.extras.put(name, value);
        }
        return this;
    }

    public ImSession addExtra(Map<String, Object> extras) {
        if (extras != null && extras.size() > 0) {
            for (String key : extras.keySet()) {
                this.addExtra(key, extras.get(key));
            }
        }
        return this;
    }

    @Deprecated
    public ImSession addExtra(JSONObject extras) {
        Map<String, Object> _extras = FastjsonUtil.toMap(extras);
        if (_extras != null && _extras.size() > 0) {
            for (String key : _extras.keySet()) {
                this.addExtra(key, _extras.get(key));
            }
        }
        return this;
    }

    public ImSession setExtra(String name, Object value) {
        if (!this.extras.containsKey(name)) {
            this.extras.remove(name);
        }
        this.extras.put(name, value);
        return this;
    }

    @Deprecated
    public ImSession setExtra(JSONObject extras) {
        Map<String, Object> _extras = FastjsonUtil.toMap(extras);
        if (_extras != null && _extras.size() > 0) {
            for (String key : _extras.keySet()) {
                this.setExtra(key, _extras.get(key));
            }
        }
        return this;
    }

    public ImSession setExtra(Map<String, Object> extras) {
        if (extras != null && extras.size() > 0) {
            for (String key : extras.keySet()) {
                this.setExtra(key, extras.get(key));
            }
        }
        return this;
    }

    public String getHeaderValue(String name) {
        return this.headers.get(name);
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public int getHeaderSize() {
        return this.headers.size();
    }

    public String getCookieData(String name) {
        return this.cookies.get(name);
    }

    public Set<String> getCookieNames() {
        return this.cookies.keySet();
    }

    public int getCookieSize() {
        return this.cookies.size();
    }

    public Object getExtraValue(String name) {
        return this.extras.get(name);
    }

    public Set<String> getExtraNames() {
        return this.extras.keySet();
    }

    public int getExtraSize() {
        return this.extras.size();
    }

    protected ImSessionCallback getCallback() {
        return this.callback;
    }

    protected Map<String, String> getHeaders() {
        return this.headers;
    }

    protected void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    protected Map<String, String> getCookies() {
        return this.cookies;
    }

    protected void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }
}

