/**
 * Copyright (c) 2019, Sinlmao (888@1st.com).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.sinlmao.commons.network.http;

/**
 * <p> program: Sinlmao Commons Network Utils
 * <p> description: 常见User-Agent（UA）
 * <p> create: 2019-11-11 10:08
 *
 * @author Sinlmao
 * @since 1.4.3
 */
public class ImUserAgent {

    /**
     * PC端Windows Chrome浏览器UA
     * <p>
     * 采集版本：78.0.3904.97
     * <p>
     * <font color="#666666">PC side Windows Chrome browser UA</font>
     * <p>
     * <font color="#666666">Acquisition version: 78.0.3904.97</font>
     */
    public final static String UA_PC_WINDOWS_CHROME = "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36";

    /**
     * PC端Windows Firefox浏览器UA
     * <p>
     * 采集版本：70.0.1
     * <p>
     * <font color="#666666">PC side Windows Firefox browser UA</font>
     * <p>
     * <font color="#666666">Acquisition version: 70.0.1</font>
     */
    public final static String UA_PC_WINDOWS_FIREFOX = "Mozilla/5.0 (Windows NT 10.0) Gecko/20100101 Firefox/70.0";

    /**
     * PC端Windows Opera浏览器UA
     * <p>
     * 采集版本：64.0.3417.92
     * <p>
     * <font color="#666666">PC side Windows Opera browser UA</font>
     * <p>
     * <font color="#666666">Acquisition version: 64.0.3417.92</font>
     */
    public final static String UA_PC_WINDOWS_OPERA = "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.92";

    /**
     * PC端Windows Edge浏览器UA
     * <p>
     * 采集版本：79.0.309.15
     * <p>
     * <font color="#666666">PC side Windows Edge browser UA</font>
     * <p>
     * <font color="#666666">Acquisition version: 79.0.309.15</font>
     */
    public final static String UA_PC_WINDOWS_EDGE_NEW = "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.16 Safari/537.36 Edg/79.0.309.15";

    /**
     * PC端Windows Edge浏览器UA
     * <p>
     * 采集版本：15.15063
     * <p>
     * <font color="#666666">PC side Windows Edge browser UA</font>
     * <p>
     * <font color="#666666">Acquisition version: 15.15063</font>
     */
    public final static String UA_PC_WINDOWS_EDGE = "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36 Edge/15.15063";

    /**
     * PC端Windows 微信UA
     * <p>
     * 采集版本：70.0.1
     * <p>
     * <font color="#666666">PC side Windows WeChat UA</font>
     * <p>
     * <font color="#666666">Acquisition version: WeChat 7.0.5</font>
     */
    public final static String UA_PC_WINDOWS_WEIXIN = "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.116 Safari/537.36 QBCore/4.0.1278.400 QQBrowser/9.0.2524.400 Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2875.116 Safari/537.36 NetType/WIFI MicroMessenger/7.0.5 WindowsWechat";

    /**
     * PC端Windows Internet Explorer(IE) 6 浏览器UA
     * <p>
     * 采集版本：6
     * <p>
     * <font color="#666666">PC side Windows Internet Explorer(IE) 6 browser UA</font>
     * <p>
     * <font color="#666666">Acquisition version: 6</font>
     */
    public final static String UA_PC_WINDOWS_IE6 = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)";

    /**
     * PC端Windows Internet Explorer(IE) 7 浏览器UA
     * <p>
     * 采集版本：7
     * <p>
     * <font color="#666666">PC side Windows Internet Explorer(IE) 7 browser UA</font>
     * <p>
     * <font color="#666666">Acquisition version: 7</font>
     */
    public final static String UA_PC_WINDOWS_IE7 = "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)";

    /**
     * PC端Windows Internet Explorer(IE) 8 浏览器UA
     * <p>
     * 采集版本：8
     * <p>
     * <font color="#666666">PC side Windows Internet Explorer(IE) 9 browser UA</font>
     * <p>
     * <font color="#666666">Acquisition version: 8</font>
     */
    public final static String UA_PC_WINDOWS_IE8 = "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0)";

    /**
     * PC端Windows Internet Explorer(IE) 9 浏览器UA
     * <p>
     * 采集版本：9
     * <p>
     * <font color="#666666">PC side Windows Internet Explorer(IE) 9 browser UA</font>
     * <p>
     * <font color="#666666">Acquisition version: 9</font>
     */
    public final static String UA_PC_WINDOWS_IE9 = "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)";

    /**
     * PC端Windows Internet Explorer(IE) 10 浏览器UA
     * <p>
     * 采集版本：7
     * <p>
     * <font color="#666666">PC side Windows Internet Explorer(IE) 10 browser UA</font>
     * <p>
     * <font color="#666666">Acquisition version: 10</font>
     */
    public final static String UA_PC_WINDOWS_IE10 = "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 10.0; WOW64; Trident/7.0)";

    /**
     * PC端Windows Internet Explorer(IE) 11 浏览器UA
     * <p>
     * 采集版本：7
     * <p>
     * <font color="#666666">PC side Windows Internet Explorer(IE) 11 browser UA</font>
     * <p>
     * <font color="#666666">Acquisition version: 11</font>
     */
    public final static String UA_PC_WINDOWS_IE11 = "Mozilla/5.0 (Windows NT 10.0; Trident/7.0) like Gecko";

    /**
     * iPhone端微信UA
     * <p>
     * 采集版本：iOS 12 / 微信 6.3.22
     * <p>
     * <font color="#666666">iPhone WeChat UA</font>
     * <p>
     * <font color="#666666">Acquisition version: iOS 12 / WeChat 7.0.8</font>
     */
    public final static String UA_IPHONE_WEIXIN = "Mozilla/5.0 (iPhone; CPU iPhone OS 12_4_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 MicroMessenger/7.0.8(0x17000820) NetType/WIFI Language/zh_CN";

    /**
     * iPhone端UA
     * <p>
     * 采集版本：iOS 10.1
     * <p>
     * <font color="#666666">iPhone UA</font>
     * <p>
     * <font color="#666666">Acquisition version: OS 12</font>
     */
    public final static String UA_IPHONE = "Mozilla/5.0 (iPhone; CPU iPhone OS 12_4_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Mobile/15E148 Safari/604.1";

    /**
     * Android端UA
     * <p>
     * 采集版本：Android 8.1.0
     * <p>
     * <font color="#666666">Android UA</font>
     * <p>
     * <font color="#666666">Acquisition version: Android 8.1.0</font>
     */
    public final static String UA_ANDROID = "Mozilla/5.0 (Linux; U; Android 10; zh-cn; LIO-AL00 Build/HUAWEILIO-AL00) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/66.0.3359.126 MQQBrowser/9.8 Mobile Safari/537.36";

    /**
     * Android端微信UA
     * <p>
     * 采集版本：Android 10 / 微信 7.0.8.1540
     * <p>
     * <font color="#666666">Android WeChat UA</font>
     * <p>
     * <font color="#666666">Acquisition version: Android 10 / WeChat 7.0.8.1540</font>
     */
    public final static String UA_ANDROID_WEIXIN = "Mozilla/5.0 (Linux; Android 10; LIO-AL00 Build/HUAWEILIO-AL00; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/66.0.3359.126 MQQBrowser/6.2 TBS/045008 Mobile Safari/537.36 MMWEBID/3848 MicroMessenger/7.0.8.1540(0x27000834) Process/tools NetType/WIFI Language/zh_CN ABI/arm64";

    /**
     * iPad端UA
     * <p>
     * 采集版本：iOS 10.2
     * <p>
     * <font color="#666666">iPad UA</font>
     * <p>
     * <font color="#666666">Acquisition version: iOS 10.2</font>
     */
    public final static String UA_IPAD = "Mozilla/5.0 (iPad; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 MQQBrowser/7.4.1 Mobile/14C92 Safari/8536.25 MttCustomUA/2 QBWebViewType/1";

    /**
     * OSX端UA
     * <p>
     * 采集版本：OSX
     * <p>
     * <font color="#666666">OSX UA</font>
     * <p>
     * <font color="#666666">Acquisition version: OSX 10.15</font>
     */
    public final static String UA_OSX = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.2 Safari/605.1.15";


    /**
     * OSX端微信UA
     * <p>
     * 采集版本：iOS 10.2
     * <p>
     * <font color="#666666">OSX WeChat UA</font>
     * <p>
     * <font color="#666666">Acquisition version: iOS 10.15 / WeChat 2.3.27</font>
     */
    public final static String UA_OSX_WEIXIN = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15) AppleWebKit/605.1.15 (KHTML, like Gecko) MicroMessenger/2.3.27(0x12031b13) MacWechat NetType/WIFI WindowsWechat";

}
