/**
 * Copyright (c) 2019, Sinlmao (888@1st.com).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.sinlmao.commons.network.exception;

/**
 * <b>证书相关异常/警告类</b>
 * <p>
 * 有关证书的使用、调用、解析异常和警告的异常抛出
 * <br/><br/>
 * <b>Certificate related exception/warning class</b>
 * <p>
 * Exception throws about usage, invocation, parsing exceptions, and warnings for certificate
 *
 * @author Sinlmao
 * <p> program: Sinlmao Commons Network Utils
 * <p> description: 证书相关异常/警告类
 * <p> create: 2020-06-17 14:42
 */
public class CertificateException extends RuntimeException {

    /**
     * 返回一个证书处理时的异常说明
     * <p>
     * <font color="#666666">Return a unauthenticated exception description</font>
     */
    public final static String ProcessingError = "Encountered an error while processing the certificate.";

    /**
     * 返回一个证书处理时的异常说明
     * <p>
     * <font color="#666666">Return a unauthenticated exception description</font>
     */
    public final static String UnsupportedStandard = "Unsupported formats and standards, please implement by yourself.";

    /**
     * 构建一个证书相关异常/警告
     * <p>
     * <font color="#666666">Build a certificate related exception/warning</font>
     *
     * @param message 异常/警告信息 <br/> <font color="#666666">Exception/warning information</font>
     */
    public CertificateException(String message) {
        super(message);
    }

    /**
     * 构建一个证书相关异常/警告
     * <p>
     * <font color="#666666">Build a certificate related exception/warning</font>
     *
     * @param message 异常/警告信息 <br/> <font color="#666666">Exception/warning information</font>
     */
    public CertificateException(String message, Throwable cause) {
        super(message, cause);
    }
}
