/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.ssl;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Vector;
import javax.net.ssl.X509KeyManager;

public final class ProtocolSSLKeyManager
implements X509KeyManager {
    protected String alias;
    protected KeyStore keyStore;
    protected char[] password;
    private final String algorithm;
    private final String issuer;

    public static ProtocolSSLKeyManager getInstance(KeyStore keyStore, char[] password) {
        return new ProtocolSSLKeyManager(keyStore, null, password);
    }

    public static ProtocolSSLKeyManager getInstance(KeyStore keyStore, String alias, char[] password) {
        return new ProtocolSSLKeyManager(keyStore, alias, password);
    }

    private ProtocolSSLKeyManager(KeyStore keyStore, String alias, char[] password) {
        this.keyStore = keyStore;
        this.alias = alias;
        this.password = password;
        try {
            Certificate c = keyStore.getCertificate(alias);
            this.algorithm = c.getPublicKey().getAlgorithm();
            this.issuer = ((X509Certificate)c).getIssuerDN().getName();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(alias + " has a bad key");
        }
    }

    @Override
    public String[] getClientAliases(String algorithm, Principal[] principals) {
        String alias = this.chooseClientAlias(new String[]{algorithm}, principals, null);
        String[] result = alias == null ? new String[]{} : new String[]{alias};
        return result;
    }

    @Override
    public String chooseClientAlias(String[] algorithms, Principal[] principals, Socket socket) {
        if (this.alias != null && !this.alias.isEmpty()) {
            return this.alias;
        }
        for (String algorithm : algorithms) {
            if (!algorithm.equals(this.algorithm)) continue;
            if (principals == null) {
                return this.alias;
            }
            for (Principal principal : principals) {
                if (!this.issuer.equals(principal.getName())) continue;
                return this.alias;
            }
        }
        return null;
    }

    @Override
    public String[] getServerAliases(String algorithm, Principal[] principals) {
        return this.getClientAliases(algorithm, principals);
    }

    @Override
    public String chooseServerAlias(String algorithm, Principal[] principals, Socket socket) {
        return this.chooseClientAlias(new String[]{algorithm}, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            Certificate[] certificates = this.keyStore.getCertificateChain(alias);
            Vector vector = new Vector(certificates.length);
            Collections.addAll(vector, certificates);
            return vector.toArray(new X509Certificate[0]);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            return (PrivateKey)this.keyStore.getKey(alias, this.password);
        }
        catch (Exception e) {
            return null;
        }
    }
}

